package cryptionclient

import (
	"encoding/base64"

	"code.justin.tv/devrel/devsite-rbac/clients/kmsclient"
)

type NoopClient struct{}

func (c *NoopClient) EncryptPlainText(plaintext []byte) (encryptedDataKey *kmsclient.EncryptedDataKey, ciphertext []byte, err error) {
	var target []byte
	base64.StdEncoding.Encode(plaintext, target)
	return &kmsclient.EncryptedDataKey{
		KeyARN: "keyARN",
		Region: "us-west-2",
		Value:  target,
	}, target, nil
}

func (c *NoopClient) DecryptPlainText(dataKey *kmsclient.EncryptedDataKey, ciphertext []byte) (string, error) {
	result, err := base64.StdEncoding.DecodeString(string(dataKey.Value))
	return string(result), err
}
