package discovery

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestSplitInBatches(t *testing.T) {
	batches := splitInBatches([]string{}, 50)
	require.Len(t, batches, 0)

	batches = splitInBatches([]string{"666"}, 50)
	require.Len(t, batches, 1)
	require.Len(t, batches[0], 1)
	require.Equal(t, "666", batches[0][0])

	batches = splitInBatches([]string{"1", "2", "3", "4", "5", "6", "7"}, 3)
	require.Len(t, batches, 3)
	require.Equal(t, []string{"1", "2", "3"}, batches[0])
	require.Equal(t, []string{"4", "5", "6"}, batches[1])
	require.Equal(t, []string{"7"}, batches[2])
}
