package discovery

import (
	"context"
	"strconv"

	dclient "code.justin.tv/web/discovery/client"
)

// NoopClient implements the Discovery interface as a NOOP,
// to provide predictable game results in a test environment.
type NoopClient struct{}

// GetAll returns fake game data for each game requested.
func (d *NoopClient) GetAll(ctx context.Context, ids []string) (map[string]*dclient.LocalizedGame, error) {
	results := make(map[string]*dclient.LocalizedGame)
	for _, id := range ids {
		intID, _ := strconv.Atoi(id)
		results[id] = &dclient.LocalizedGame{
			Game: dclient.Game{
				Name: id,
				ID:   intID,
			},
		}
	}
	return results, nil
}
