package evs

import (
	"context"
)

// NoopClient implements the EVS interface as a NOOP,
// to provide predictable results in a test environment.
type NoopClient struct{}

// SendVerificationEmail does nothing
func (c *NoopClient) SendVerificationEmail(ctx context.Context, evsKey string, email string, purpose string) error {
	return nil
}

// GetVerificationStatus does nothing
func (c *NoopClient) GetVerificationStatus(ctx context.Context, evsKey string, email string) string {
	return "Unknown"
}

// DeleteVerificationStatus does nothing
func (c *NoopClient) DeleteVerificationStatus(ctx context.Context, evsKey string, email string) error {
	return nil
}
