package extensions

import (
	"context"
)

// FakeClient implements the interface with configurable results for tests.
type FakeClient struct {
	GetExtensionReturnsError             error // configure GetExtension to fail with this error
	TransitionExtensionStateReturnsError error // configure TransitionExtensionState to fail with this error
}

// GetExtension fake implementation
func (c *FakeClient) GetExtensionVersion(ctx context.Context, extensionID string, extensionVersion string, cartmanToken string) (*ExtensionVersion, error) {
	if c.GetExtensionReturnsError != nil {
		return nil, c.GetExtensionReturnsError
	}
	return &ExtensionVersion{
		ID:      extensionID,
		Version: extensionVersion,
		Name:    "Fake Extension " + extensionID + "(" + extensionVersion + ")",
	}, nil
}

func (c *FakeClient) TransitionExtensionState(ctx context.Context, extensionID, version, state, cartmanToken string) error {
	if c.TransitionExtensionStateReturnsError != nil {
		return c.TransitionExtensionStateReturnsError
	}
	return nil
}
