package salesforce

import (
	"context"
)

// NoopClient implements the Salesforce interface as a NOOP,
// to provide predictable results in a test environment.
type NoopClient struct {
	CreateExtensionReviewCaseReturnsError error
}

func (s *NoopClient) Initialize(ctx context.Context) error {
	return nil
}
func (s *NoopClient) CreateExtensionReviewCase(ctx context.Context, extCase ExtensionReviewCase) (string, error) {
	return "foobar", nil
}
