--
-- PostgreSQL database dump
--

-- Dumped from database version 12.2
-- Dumped by pg_dump version 12.2

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: pg_trgm; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS pg_trgm WITH SCHEMA public;


--
-- Name: EXTENSION pg_trgm; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION pg_trgm IS 'text similarity measurement and index searching based on trigrams';


--
-- Name: uuid-ossp; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA public;


--
-- Name: EXTENSION "uuid-ossp"; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION "uuid-ossp" IS 'generate universally unique identifiers (UUIDs)';


--
-- Name: extension_review_state; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE public.extension_review_state AS ENUM (
    'review',
    'approved',
    'pending_action'
);


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: action_histories; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.action_histories (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    action character varying(250),
    created_at timestamp without time zone,
    entity_id character varying(250) NOT NULL,
    entity_type character varying(250) NOT NULL,
    user_twitch_id character varying(50) NOT NULL,
    company_id uuid
);


--
-- Name: companies; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.companies (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    company_name character varying(250),
    url character varying(150),
    type integer,
    vhs_contract_signed boolean,
    campaigns_enabled boolean,
    identifier character varying(250),
    curse_company_id integer,
    created_at timestamp without time zone,
    legacy boolean DEFAULT false
);


--
-- Name: company_applications; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.company_applications (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    company_name character varying(250),
    company_website character varying(150),
    company_type integer,
    games character varying(100),
    industry character varying(50),
    company_size character varying(50),
    city character varying(50),
    state character varying(50),
    country character varying(50),
    contact_first_name character varying(50),
    contact_last_name character varying(50),
    contact_title character varying(50),
    contact_email character varying(50),
    product_interest character varying(500),
    join_reason character varying(500),
    twitch_id character varying(50) NOT NULL,
    status integer NOT NULL,
    created_at timestamp without time zone,
    updated_at timestamp without time zone
);


--
-- Name: company_invites; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.company_invites (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    company_id uuid NOT NULL,
    invitee_twitch_id character varying(50) NOT NULL,
    inviter_twitch_id character varying(50) NOT NULL,
    role character varying(64) NOT NULL,
    created_at timestamp without time zone NOT NULL
);


--
-- Name: company_resources; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.company_resources (
    company_id uuid NOT NULL,
    resource_id text NOT NULL,
    resource_type text NOT NULL
);


--
-- Name: developer_applications; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.developer_applications (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    company_id uuid,
    twitch_id character varying(50),
    first_name character varying(64),
    last_name character varying(64),
    title character varying(64),
    email character varying(64),
    created_at timestamp without time zone DEFAULT now()
);


--
-- Name: extension_billing_manager; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.extension_billing_manager (
    extension_client_id text NOT NULL,
    billing_manager_twitch_id character varying(50),
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


--
-- Name: extension_review_logs; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.extension_review_logs (
    id integer NOT NULL,
    created_at timestamp without time zone DEFAULT now(),
    state public.extension_review_state,
    author_twitch_id character varying(50),
    author_notes text,
    author_channel character varying(64),
    extension_id character varying(50),
    extension_version character varying(50),
    reviewer_twitch_id character varying(50),
    review_reason_codes text[],
    review_reason text,
    salesforce_case_id character varying(50)
);


--
-- Name: extension_review_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.extension_review_logs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: extension_review_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.extension_review_logs_id_seq OWNED BY public.extension_review_logs.id;


--
-- Name: feature_gating; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.feature_gating (
    feature_gating_key character varying(250) NOT NULL,
    feature_gating_value_in_bool boolean,
    feature_gating_value_in_strings text[]
);


--
-- Name: game_applications; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.game_applications (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    game_id integer,
    created_at timestamp without time zone,
    company_id uuid
);


--
-- Name: memberships; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.memberships (
    twitch_id character varying(50) NOT NULL,
    company_id uuid NOT NULL,
    role text NOT NULL,
    first_name character varying(64) NOT NULL,
    last_name character varying(64) NOT NULL,
    dev_title character varying(64) DEFAULT ''::character varying NOT NULL,
    dev_email character varying(64) NOT NULL,
    created_at timestamp without time zone NOT NULL,
    modified_at timestamp without time zone
);


--
-- Name: resource_types; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.resource_types (
    identifier character varying(250) NOT NULL,
    description text,
    external_id character varying(50),
    type character varying(50)
);


--
-- Name: schema_migrations; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.schema_migrations (
    version bigint NOT NULL,
    dirty boolean NOT NULL
);


--
-- Name: user_whitelist; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.user_whitelist (
    twitch_id character varying(50) NOT NULL,
    role character varying(50) NOT NULL
);


--
-- Name: extension_review_logs id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.extension_review_logs ALTER COLUMN id SET DEFAULT nextval('public.extension_review_logs_id_seq'::regclass);


--
-- Name: action_histories action_histories_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.action_histories
    ADD CONSTRAINT action_histories_pkey PRIMARY KEY (id);


--
-- Name: companies companies_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.companies
    ADD CONSTRAINT companies_pkey PRIMARY KEY (id);


--
-- Name: company_applications company_applications_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.company_applications
    ADD CONSTRAINT company_applications_pkey PRIMARY KEY (id);


--
-- Name: company_invites company_invites_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.company_invites
    ADD CONSTRAINT company_invites_pk UNIQUE (company_id, invitee_twitch_id);


--
-- Name: company_invites company_invites_pk2; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.company_invites
    ADD CONSTRAINT company_invites_pk2 PRIMARY KEY (id);


--
-- Name: company_resources company_resources_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.company_resources
    ADD CONSTRAINT company_resources_pkey PRIMARY KEY (company_id, resource_id, resource_type);


--
-- Name: extension_billing_manager extension_billing_manager_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.extension_billing_manager
    ADD CONSTRAINT extension_billing_manager_pkey PRIMARY KEY (extension_client_id);


--
-- Name: extension_review_logs extension_review_logs_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.extension_review_logs
    ADD CONSTRAINT extension_review_logs_pkey PRIMARY KEY (id);


--
-- Name: feature_gating feature_gating_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.feature_gating
    ADD CONSTRAINT feature_gating_pkey PRIMARY KEY (feature_gating_key);


--
-- Name: game_applications game_applications_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.game_applications
    ADD CONSTRAINT game_applications_pkey PRIMARY KEY (id);


--
-- Name: memberships memberships_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.memberships
    ADD CONSTRAINT memberships_pkey PRIMARY KEY (company_id, twitch_id);


--
-- Name: schema_migrations schema_migrations_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.schema_migrations
    ADD CONSTRAINT schema_migrations_pkey PRIMARY KEY (version);


--
-- Name: user_whitelist twitch_id; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.user_whitelist
    ADD CONSTRAINT twitch_id PRIMARY KEY (twitch_id);


--
-- Name: company_invites_company_id_invitee_twitch_id_index; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX company_invites_company_id_invitee_twitch_id_index ON public.company_invites USING btree (company_id, invitee_twitch_id);


--
-- Name: company_invites_id_uindex; Type: INDEX; Schema: public; Owner: -
--

CREATE UNIQUE INDEX company_invites_id_uindex ON public.company_invites USING btree (id);


--
-- Name: memberships_twitch_id_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX memberships_twitch_id_idx ON public.memberships USING btree (twitch_id);


--
-- Name: game_applications FK_game_applications_game; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.game_applications
    ADD CONSTRAINT "FK_game_applications_game" FOREIGN KEY (company_id) REFERENCES public.companies(id);


--
-- Name: company_invites company_invites_companies_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.company_invites
    ADD CONSTRAINT company_invites_companies_id_fk FOREIGN KEY (company_id) REFERENCES public.companies(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: company_resources company_resources_company_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.company_resources
    ADD CONSTRAINT company_resources_company_id_fkey FOREIGN KEY (company_id) REFERENCES public.companies(id);


--
-- Name: memberships memberships_company_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.memberships
    ADD CONSTRAINT memberships_company_id_fkey FOREIGN KEY (company_id) REFERENCES public.companies(id);


--
-- Name: SCHEMA public; Type: ACL; Schema: -; Owner: -
--

GRANT ALL ON SCHEMA public TO rbac_admin;


--
-- PostgreSQL database dump complete
--

