# RBAC Architecture

![Architecture Diagram](architecture_diagram.png)

#### RBAC API

RBAC API is implemented with [Twirp](https://github.com/twitchtv/twirp). Check the [proto file](/rpc/rbacrpc/rbacrpc.proto) to see all service methods and types.

In the proto file, there are some sub-services to organize the API. See [/rpc/extensionreviewsserver](/rpc/extensionreviewsserver) README for more info about the Extensions Review Service.

#### Callers

 * Edge (Visage, GraphQL): authenticate requests using Cartman and send a `Twitch-Authorization` header with the HTTP request.
 * Vienna: is a frontend running inside the Twitch VPN that sends requests to the RBAC API directly from JavaScript. Viena requests have an OAuth token in the `Authorization` header (but have not been signed by Carman).
 * Other Services: use the RBAC API to check organizations and resource ownership.

API consumers use the auto-generated Twirp clients to easily make type-safe calls to the API.

#### AWS Infra

RBAC is an ElasticBeanstalk application using a postgres relational database hosted on RDS. To see more details, check the terraform project: https://git-aws.internal.justin.tv/devrel/devsite-rbac-tf, although note that there's some drift (tf state is no longer maintained because it is overkill for RBAC infra).
