# RBAC Postgres Database

## Local Database

Install postgres tools: `brew install postgres`. Use `brew info postgres` to see caveats and instructions on how to start the database locally.

The easiest way to get a local database working is to dump the stagin database:

 * `make pg_dump_setup` (first time only, to create rbac DB and users)
 * `make pg_dump_staging_to_local` (need AWS CLI setup for the password secret)
 * Connect with `make psql_local`
 * Run RBAC localy against this DB with `make run_local`

## Schema Migrations

Setup:

 * Make sure you have the local database setup to test the migrations.
 * Install: `brew install golang-migrate`. The [https://github.com/golang-migrate/migrate](migrate) tool is used to run migrations.

Write and test a new migration:

 * Add new file: `migrations/<version>_<name>.up.sql`, with consecutive version number, and make sure has suffix `.up.sql`. Write SQL.
 * Test migration against local DB: `make migrate_local`. If the migration goes wrong, re-bulild the db from staging (`make pg_dump_staging_to_local`) or fix manually (revert partial changes) and try again.
 * When done, update e2e schema file: `make pg_dump_local_to_e2e_schema`, then run `make e2e` tests with the new schema.

Other migration commands may be useful for debugging (see `migrate -h`). For example, see current version: `migrate -path migrations -database <url> version` (or check the `schema_migrations` table in the DB).

Apply:

 * Since the migration is part of a Pull Request, make sure to address feedback and re-run locally to make sure it works as expected.
 * Usually the migration needs to be applied in the DB before deploying your code. When you are about to merge and deploy, run the migrations from your local machine.
 * Run in staging: `make migrate_staging`. You will be prompted to enter `y` to proceed. This is extra protection from accidentally running a migration in staging or production.
 * Run in production: `make migrate_production`.
 * Notify peers in Slack that the migration has been applied. They may have another migration pending in their branch and they need to bump the version number.

DB Migration FAQ:

 * Q: Should we create migrations with `migrate create` command? A: No, that will create the file with a timestamp instead of a numerical version. For small teams like ours, numerical versions are easier to manage because they make conflicts easy to detect: if you merge master into your branch and another migration was added before, it will cause a collision, with a timestamp you would never know and your local DB will stay out of date.
 * Q: Should we write `*.down.sql` files for rollback? A: It is optional. If you find it useful go for it. But most of the time, if a migration fails it will be in the middle of it, so the down rollback will not work, you will have to fix it manually anyways.

## Remote Databases

The databases are AWS RDS instances.

Use `make psql_staging` and `make psql_production` to connect with psql.

### DB Restoration

In the event that the database supporting RBAC fails or data is corrupted, we will need to restore data from a snapshot.

RBAC is currently backed by a RDS Postgres instance with automatic backups that go back two weeks. It is hosted in the Oregon / us-west-2 region. It is configured to be multi-AZ, which means there should always be a backup ready for automatic failover should something happen to the master, with a 60-120 second blip. If both the master and the backup fail, then restoration will be necessary.

#### Manual Restoration

Terraform is not used anymore on RBAC. You can check the tf files on https://git-aws.internal.justin.tv/devrel/devsite-rbac-tf for reference, but there's no need to keep the tf state up-to-date.

To restore a DB, you can manually spin up a new instance from a snapshot or point in time to create a new database instance.

#### New Instance from Snapshot

When viewing a snapshot in the AWS Console, you may choose to `Restore Snapshot`. This will take you to another screen to configure the new instance that will be created. You need to set the `DB Instance Identifier` manually. Be sure to set the VPC to `twitch-rbac-${env}` (failure to do this will spin up the instance on a network we can't access). The `default` subnet group will be used initially. After instance has come online, you need to remove the `default` subnet group and add the `twitch-internal` subnet group.

#### Restore to a Point in Time

When viewing a RDS instance, you may choose to `Restore to a point in time`. This will create a new instance, and currently has the same flow as the `New Instance from Snapshot` section.

AWS does warn that this can take several hours to complete due to transaction logs that need to be applied. I believe this is for restoring to a custom point in time, which may be between snapshots.

#### DB Credentials

After the DB instance comes up, the master password may need to be reset if it was a manual restoration. Once that is done, connect to the db as admin (currently `rbac_admin`) and verify the RBAC credentials in aws secrets manager match those in the DB. Ensure the role RBAC will be using has read & write access to all essential tables.

### Restoring a Prod Snapshot to Staging

To create a copy of the production RBAC database into Staging you will first need to create a snapshot of the production database. Connect to the twitch-rbac-prod console and navigate to the rbac-production database (rbac-production) in RDS. Then navigate to the `Maintance & backups` click on the `Take Snapshot` button to create a snapshot. Then navigate to the `Snapshots` page and select your snapshot. Next in the Actions dropdown select the `Share Snapshot` feature. Then add the AWS Account ID for the twitch-rbac-dev account. Now open the RDS console in the twitch-rbac-dev account. Go to the `Snapshots` section and open the `Shared with me` tab. You should see the snapshot you created, select it and in the Actions choose `Restore Snapshot` this will take you to another screen to configure the new instance that will be created. The `DB Instance Class` needs to be set to db.t3.medium. You need to set the `DB Instance Identifier` manually ex: `rbac-staging-2020-03-27`. Be sure to set the VPC to `twitch-rbac-staging` (failure to do this will spin up the instance on a network we can't access). The `subnet group` needs to be set to `rbac-staging-subnet` (this needs to be set now cause it cannot be changed later for Aurora clusters). Set the port to 5433. All other settings can be left to their defaults. After the instance has come online, you need to remove the default security group and add the `twitch-internal` security group.

At this point the new database is set up and you can connect to it using the new clusters writer endpoint and the credentials used for the production database, these can be found in twitch-rbac-prod Secret Manager secret admin_db_rds. After connecting you will need to change the passwords for user's rbac_02 and rbac_admin, their passwords are stored in twitch-rbac-dev Secret manager secrets admin_db_rds and db_rds. Use this script to update the passwords `ALTER ROLE [username] WITH PASSWORD [password]`. After this point you will need to use the staging password to connect to the new DB.

If this new DB instance is being used for staging you will need to update the db_rds secret in Secret Manager on the twitch-rbac-dev console. You will need to update the `host` to th host name of the new instance and the `dbInstanceIdentifier` to the name of the new instance. After setting these run `make run_staging` to verify the connection string works then go into Elastic Beanstalk on twitch-rbac-dev and `Restart the App Server` for staging-devsite-rbac-server for the changes to take effect.

