# Oncall Runbook

RBAC is a go service running in ElasticBeanstalk with a postresql RDS data store.

## Oncall Preparation

 * General Preparation: https://wiki.twitch.com/display/DS/Oncall+Preparation
 * AWS accounts: `twitch-rbac-prod` and `twitch-rbac-dev`
 * Slack channel: `#twitch-rbac`
 * Grafana dashboard: https://grafana.internal.justin.tv/d/000000867/rbac
 * Rollbar: https://rollbar.com/Twitch/RBAC

## Deployments

[clean-deploy](https://clean-deploy.internal.justin.tv/#/devrel/devsite-rbac) is used for deployments. Deploy to staging first to test changes before going to production.

If a deployment fails, one or more batches of the fleet will be out of service. Deploy the last good commit for recovery.

## Errors

[Rollbar](https://rollbar.com/Twitch/RBAC) is used to monitor errors.

## Monitoring

[Grafana](https://grafana.internal.justin.tv/d/000000867/rbac?) has the best graph to view health of RBAC.

## Infrastructure

The terraform lives in [devrel/devsite-rbac-tf](https://git-aws.internal.justin.tv/devrel/devsite-rbac-tf).

### DNS and SSL Certificates

Last update to DNS is documented in this JIRA: https://jira.twitch.com/browse/INS-1500. The current configuration uses a different host zone on each account (prod and staging): Route53 has a delegated hosted zone, Certificate Manager has the SSL Certificate and the Beanstalk Load Balancer is configured to use the certificate on port 443 (default for https). The load balancer is managed in terraform, but certificates and Route 53 records are edited manually through the AWS console.


## Recipes

### Salesforce API errors

Salesforce is only used on `ExtensionReviews.SetStateInReview`, and sometimes may drop errors on Slack that may page you.

The Salesforce API and configuration is out of our control, but we monitor if the API calls are responding properly, and returning internal errors if they don't. If you are paged or see Salesforce errors in Rollbar, don't worry because Salesforce errors will do not prevent our users from keep using our services, but you should contact Hanna Murray (@CobraShark) or someone in the Moderation team (@Sanyu, @Flamegoat), or someone that knows about Salesforce (@Fahim, @Shawn). So they can fix the issue.
