package e2e

import (
	"testing"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"

	"github.com/stretchr/testify/suite"
)

func Test_CreateJWTSuite(t *testing.T) {
	s := &CreateJWTSuite{}
	suite.Run(t, s)
}

type CreateJWTSuite struct {
	Suite
}

func (s *CreateJWTSuite) Test_CreateJWT() {
	company := s.createCompany()

	twitchID := randomTwitchID()
	s.mustCreateMembership(membershipParams{
		TwitchID:  twitchID,
		CompanyID: company.Id,
		Role:      "Administrator",
	})

	// happy path
	jwt, err := s.RBAC.CreateJWT(s.AdminCtx, &rbacrpc.JWTRequest{
		Operation: "create_item",
		UserId:    twitchID,
		CompanyId: company.Id,
	})
	s.NoError(err)
	s.NotEmpty(jwt.Token)
	s.NotEmpty(jwt.AccountId)

	// no company provided. twilight doesn't always send it.
	jwt, err = s.RBAC.CreateJWT(s.AdminCtx, &rbacrpc.JWTRequest{
		Operation: "create_item",
		UserId:    twitchID,
	})
	s.NoError(err)
	s.NotEmpty(jwt.Token)
	s.NotEmpty(jwt.AccountId)

	// Expect random user to not have access
	_, err = s.RBAC.CreateJWT(s.AdminCtx, &rbacrpc.JWTRequest{
		Operation: "create_item",
		UserId:    randomTwitchID(),
		CompanyId: company.Id,
	})
	s.Error(err)

	// Legacy Case. This is removed once visage is updated to pass UserId.
	jwt, err = s.RBAC.CreateJWT(s.AdminCtx, &rbacrpc.JWTRequest{
		Operation: "create_item",
		CompanyId: company.Id,
	})
	s.NoError(err)
	s.NotEmpty(jwt.Token)
	s.NotEmpty(jwt.AccountId)
}
