package e2e

import (
	"testing"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/stretchr/testify/suite"
)

type CreateShadowAccountTestSuite struct {
	Suite
}

func Test_CreateShadowAccountTestSuite(t *testing.T) {
	s := &CreateShadowAccountTestSuite{}
	suite.Run(t, s)
}

// SetupSuite is executed only once, before the suite runs the first test
func (s *CreateShadowAccountTestSuite) SetupSuite() {
	s.Suite.SetupSuite()
}

func (s *CreateShadowAccountTestSuite) Test_CreateShadowAccount() {
	company := s.createCompany()

	resp, err := s.RBACAdmin.CreateShadowAccount(s.AdminCtx, &rbacrpc.CreateShadowAccountRequest{
		ClientId:  "client_id",
		CompanyId: company.Id,
		UserInput: []*rbacrpc.CreateShadowAccountUserInput{
			&rbacrpc.CreateShadowAccountUserInput{
				Email: "testemail@gmail.com",
			},
		},
	})
	s.NoError(err)
	s.NotNil(resp)
	s.NotEmpty(resp.Records)
	s.Equal(1, len(resp.Records))

	resp2, err := s.RBAC.ListCompanyMemberships(s.Ctx, &rbacrpc.ListCompanyMembershipsRequest{
		TwitchId: resp.Records[0].TwitchId,
	})
	s.NoError(err)
	var membershipPtr *rbacrpc.CompanyMembership = nil
	for _, membership := range resp2.Memberships {
		if membership.Company.Id == company.Id {
			membershipPtr = membership
		}
	}
	s.NotNil(membershipPtr)
	s.Equal(company.Id, membershipPtr.Company.Id)
}
