package e2e

import (
	"testing"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/stretchr/testify/suite"
	"github.com/twitchtv/twirp"
)

type GetPaginatedShadowAccountsTestSuite struct {
	Suite
}

func Test_GetPaginatedShadowAccountsTestSuite(t *testing.T) {
	s := &GetPaginatedShadowAccountsTestSuite{}
	suite.Run(t, s)
}

// SetupSuite is executed only once, before the suite runs the first test
func (s *GetPaginatedShadowAccountsTestSuite) SetupSuite() {
	s.Suite.SetupSuite()
}

func (s *GetPaginatedShadowAccountsTestSuite) Test_GetUsersByCompanyId() {
	company := s.createCompany()
	resp, err := s.RBACAdmin.CreateShadowAccount(s.AdminCtx, &rbacrpc.CreateShadowAccountRequest{
		ClientId:  "client_id",
		CompanyId: company.Id,
		UserInput: []*rbacrpc.CreateShadowAccountUserInput{
			&rbacrpc.CreateShadowAccountUserInput{
				Email: "testemail@gmail.com",
			},
			&rbacrpc.CreateShadowAccountUserInput{
				Email: "testemail2@gmail.com",
			},
		},
	})
	s.NoError(err)
	s.NotNil(resp)
	s.NotEmpty(resp.Records)
	s.Equal(2, len(resp.Records))

	limit := uint64(100)
	resp2, err := s.RBAC.GetPaginatedShadowAccounts(s.Ctx, &rbacrpc.GetPaginatedShadowAccountsRequest{
		Limit: limit,
	})
	s.NoError(err)
	s.True(resp2.NextOffset == uint64(len(resp2.TwitchIds)))
	s.True(hasSubset(resp2.GetTwitchIds(), []string{resp.Records[0].TwitchId, resp.Records[1].TwitchId}))
}

func (s *GetPaginatedShadowAccountsTestSuite) Test_GetUsersByCompanyId_InvalidLimit() {
	_, err := s.RBAC.GetPaginatedShadowAccounts(s.Ctx, &rbacrpc.GetPaginatedShadowAccountsRequest{
		Limit: 2000,
	})
	s.EqualErrorCode(err, twirp.InvalidArgument)
	s.EqualErrorMsg(err, "The limit exceeds the maximum number: 1000")
}

func hasSubset(longerSlice, shorterSlice []string) bool {
	m := make(map[string]struct{}, len(longerSlice))
	for _, str := range longerSlice {
		m[str] = struct{}{}
	}

	for _, str := range shorterSlice {
		if _, ok := m[str]; !ok {
			return false
		}
	}

	return true
}
