package e2e

import (
	"testing"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/stretchr/testify/suite"
)

type UserWhitelistSuite struct {
	Suite
}

func Test_UserWhitelistSuite(t *testing.T) {
	s := &UserWhitelistSuite{}
	suite.Run(t, s)
}

func (s *UserWhitelistSuite) Test_WhitelistUser() {
	twitchIDToWhitelist := randomTwitchID()

	mockRequest := &rbacrpc.WhitelistUserRequest{
		TwitchId: twitchIDToWhitelist,
		Role:     rbacrpc.WhitelistUserRole_VIEWER,
	}

	_, err := s.RBACAdmin.WhitelistUser(s.AdminCtx, mockRequest)
	s.NoError(err)
}

func (s *UserWhitelistSuite) Test_WhitelistUser_caller_unauthorized() {
	twitchIDToWhitelist := randomTwitchID()
	callerId := randomTwitchID()

	s.AdminCtx = s.withAuth(s.AdminCtx, callerId) // mock caller as unwhitelisted user

	mockRequest := &rbacrpc.WhitelistUserRequest{
		TwitchId: twitchIDToWhitelist,
		Role:     rbacrpc.WhitelistUserRole_VIEWER,
	}

	_, err := s.RBACAdmin.WhitelistUser(s.AdminCtx, mockRequest)
	s.Error(err)
}

func (s *UserWhitelistSuite) Test_RemoveUserFromWhitelist() {
	twitchIDToWhitelist := randomTwitchID()

	mockRequest := &rbacrpc.WhitelistUserRequest{
		TwitchId: twitchIDToWhitelist,
		Role:     rbacrpc.WhitelistUserRole_VIEWER,
	}

	mockRemoveRequest := &rbacrpc.RemoveUserFromWhitelistRequest{
		TwitchId: twitchIDToWhitelist,
	}

	// whitelist user first
	_, err := s.RBACAdmin.WhitelistUser(s.AdminCtx, mockRequest)
	s.NoError(err)

	//remove user from whitelist
	_, err = s.RBACAdmin.RemoveUserFromWhitelist(s.AdminCtx, mockRemoveRequest)
	s.NoError(err)
}

func (s *UserWhitelistSuite) Test_UpdateUserRoleInWhitelist() {
	twitchIDToWhitelist := randomTwitchID()

	mockWhitelistRequest := &rbacrpc.WhitelistUserRequest{
		TwitchId: twitchIDToWhitelist,
		Role:     rbacrpc.WhitelistUserRole_VIEWER,
	}

	mockUpdateRequest := &rbacrpc.WhitelistUserRequest{
		TwitchId: twitchIDToWhitelist,
		Role:     rbacrpc.WhitelistUserRole_ADMIN,
	}
	// whitelist user first
	_, err := s.RBACAdmin.WhitelistUser(s.AdminCtx, mockWhitelistRequest)
	s.NoError(err)

	// update user role in whitelist
	_, err = s.RBACAdmin.UpdateUserRoleInWhitelist(s.AdminCtx, mockUpdateRequest)
	s.NoError(err)
}

func (s *UserWhitelistSuite) Test_ListUserWhitelistByRole_Caller_Viewer() {
	role := rbacrpc.WhitelistUserRole_ADMIN

	// caller doesn't need to be Admin
	s.AdminCtx = s.withAuth(s.AdminCtx, "TEST_VIEWER_TWITCH_ID")

	mockRequest := &rbacrpc.ListUserWhitelistByRoleRequest{
		Role: role,
	}

	resp, err := s.RBACAdmin.ListUserWhitelistByRole(s.AdminCtx, mockRequest)
	s.NoError(err)
	s.Equal(resp.Users[0].TwitchId, WhitelistAdminTwitchId)
}

func (s *UserWhitelistSuite) Test_ListUserWhitelistByRole_Caller_Unauthorized() {
	role := rbacrpc.WhitelistUserRole_ADMIN
	callerId := randomTwitchID()

	// caller doesn't need to be Admin
	s.AdminCtx = s.withAuth(s.AdminCtx, callerId)

	mockRequest := &rbacrpc.ListUserWhitelistByRoleRequest{
		Role: role,
	}

	_, err := s.RBACAdmin.ListUserWhitelistByRole(s.AdminCtx, mockRequest)
	s.Error(err)
}
