import { Stack, Construct, StackProps } from '@aws-cdk/core';
import { Certificate, ValidationMethod } from '@aws-cdk/aws-certificatemanager';
import { PROD_ACCOUNT_ID } from './consts';

// interface CertStackProps extends StackProps {}

export class CertStack extends Stack {
  public readonly RBAC_CERT: Certificate;
  constructor(scope: Construct, name: string, props: StackProps) {
    super(scope, name, props);

    const prod = props.env!.account === PROD_ACCOUNT_ID;

    this.RBAC_CERT = new Certificate(this, 'Rbac', {
      domainName: (prod ? 'prod' : 'staging') + '.devsite-rbac.twitch.a2z.com',
      subjectAlternativeNames: [
        '*.' + (prod ? 'prod' : 'staging') + '.devsite-rbac.twitch.a2z.com',
        'devsite-rbac' + (prod ? '' : '-staging') + '.internal.justin.tv',
      ],
      validationMethod: ValidationMethod.DNS,
    });
  }
}
