import { Environment } from '@aws-cdk/core';

export const DEV_ACCOUNT_ID = '059023621032';
export const PROD_ACCOUNT_ID = '712827439730';
export const PRIMARY_REGION = 'us-west-2';
export const DISASTER_REGION = 'us-east-2';
export const DEV_CERT_ARN = 'arn:aws:acm:us-west-2:059023621032:certificate/89a785ae-ac3c-49eb-b326-2d4e6cbdeb07';
export const PROD_CERT_ARN = 'arn:aws:acm:us-west-2:712827439730:certificate/e1ad6899-e0c5-4816-816d-26abc08fc1da';
export const DEV_VPC_ID = 'vpc-5855df3f';
export const PROD_VPC_ID = 'vpc-dd68e2ba';
export const DEV_GITHUB_URL = 'https://git.xarth.tv/lifecycle/devsite-rbac.git';
export const PROD_GITHUB_URL = 'https://git.xarth.tv/lifecycle/devsite-rbac.git';
export const PROD_GITHUB_VPCE_ID = 'vpce-01e46d06dda672edf';
export const DEV_GITHUB_VPCE_ID = 'vpce-0c1d181c178bb936a';
export const PROD_GITHUB_VPCE_URL =
  'vpce-01e46d06dda672edf-nzstm1h3.vpce-svc-02d9c29bb653310a1.us-west-2.vpce.amazonaws.com';
export const GITHUB_VPCE_HOSTED_ZONE = 'Z1YSA3EXCYUU9Z';
export const DEV_GITHUB_VPCE_URL =
  'vpce-0c1d181c178bb936a-x6kl5xl8.vpce-svc-02d9c29bb653310a1.us-west-2.vpce.amazonaws.com';
export const PROD_INTERNAL_SG_ID = 'sg-270c9c5f';
export const DEV_INTERNAL_SG_ID = 'sg-a70b9bdf';
export const PROD_HOSTED_ZONE_ID = 'Z3K46PHHBFGYW3';
export const DEV_HOSTED_ZONE_ID = 'ZNAFZXTOTMFOB';
export const PROD_RBAC_A2Z = 'prod.devsite-rbac.twitch.a2z.com';
export const DEV_RBAC_A2Z = 'staging.devsite-rbac.twitch.a2z.com';

// Requires the account to have been deployed beforehand
export const DEV_ECR_URL = '059023621032.dkr.ecr.us-west-2.amazonaws.com/aws-cdk/assets';
export const PROD_ECR_URL = '712827439730.dkr.ecr.us-west-2.amazonaws.com/aws-cdk/assets';

export const PROD_PDMS_ROLE = 'arn:aws:iam::125704643346:role/PDMSLambda-CallerRole-13IIND444YKVR';
export const DEV_PDMS_ROLE = 'arn:aws:iam::895799599216:role/PDMSLambda-CallerRole-18451FI19HSXT';

export const DEV_ENV: Environment = {
  account: DEV_ACCOUNT_ID,
  region: PRIMARY_REGION,
};

export const PROD_ENV: Environment = {
  account: PROD_ACCOUNT_ID,
  region: PRIMARY_REGION,
};

export const DISASTER_ENV: Environment = {
  account: PROD_ACCOUNT_ID, // TODO: Replace with separate account
  region: DISASTER_REGION,
};
