package jwt_test

import (
	"testing"
	"time"

	"code.justin.tv/devrel/devsite-rbac/internal/jwt"

	"github.com/stretchr/testify/require"
)

func Test_EncodeRS256_DecodeRS256(t *testing.T) {
	claims := jwt.Claims{
		Audience: "🐻",
		Expires:  time.Date(2000, 1, 2, 3, 4, 0, 0, time.UTC).Unix(),
		Issuer:   "✋",
		Subject:  "👽",
	}

	// Encode with private key
	private := []byte(rsa256Pem)
	encoded, err := jwt.EncodeRS256(private, claims)
	require.NoError(t, err)

	// Decode with public key
	public := []byte(rsa256PubPem)
	decodedClaims, err := jwt.DecodeRS256(public, encoded)
	require.NoError(t, err)

	require.Equal(t, claims.Audience, decodedClaims.Audience)
	require.Equal(t, claims.Issuer, decodedClaims.Issuer)
	require.Equal(t, claims.Subject, decodedClaims.Subject)
	require.Equal(t, claims.Expires, decodedClaims.Expires)
}

//
// Test data
//

var (
	rsa256Pem = `-----BEGIN RSA PRIVATE KEY-----
MIIEpAIBAAKCAQEAwhFAG3EYPAOxg/B6LkVn3ZV00otGud+DFYX8SsZOgW77dkVH
r195YVazBdePgPahttA8R+dpXLrn3lBAKxqG8uzgkPQ7Tis1vIRxha5ZMxE2rKBq
xfcB7xMbsV6c7ozlX1fT7uS1ZajJQrvjN8JjfK0U3As1zx7E3wzcheRn4FbviBse
qkwpDLRxm3g7n+T+iXsddi37xC7o7qSCmivW+RIou3xXfZcoVRB38lOAzNytF+bq
z1jkN0Lp3iw0unMYt07ZoOlyKh5IEXKdMlAl7UURgreSqSfBv+E87Xq34T17UK+Y
A87F3dxLW40rsfynU5BzUgWDPDy09SSCE4XZiQIDAQABAoIBADTCbdRIDdebBXKi
OQVFVzR1gloPBT5ZFpEOaQWHHiawHmsL8K4r3Zrp8Cehb+EWq+ZAfHLr5cgRBCJ7
XMabIp7+aRrfWxQoSSakNxypxpRMlLmfrwd83Ki7YCb7Wty7r0wZW4Ox5+LoXTbo
T6CEF3n4sBgWcB2L9ufQ3k8ERn1Fi/lyX9bfnPQOdBCdl0uOqxTtjqI7O6WTIwrl
BJjbhckNbTMwAWsNfbSIP/h7Igi1/oMdHPHPSBwV5kg/ahoSU6d7pzDIyGqe2dLD
oCYatZ4VbVM4PgIgGNqB4G3KGj2OrEnqBaDqInY1LU7O0x3lij26b37QfXG2XEOz
+QWCIqUCgYEA5xUh6Juy3cGBxwitt/LRCRVgbJseZ296aaMEImew8h6WlySVIJWC
248x2iRkwotbT4LuO6ekRA/KGdqGibBwoOL38i+mnUagrFe8XW8CACWBoIFiIs0D
lDcP6glXg7+RX80M+jDx/waVBHRf9pRV72vN31X80/SsR7tf+rWeuesCgYEA1v5X
SmnRD1qb+EazlXY/wjF4IlqcNCb5UAJGgmVBgxj/AZw7Gi75SnzvztyWNnLuj7nJ
1A3TM9c14TYDLAfc07tZPIZ0ZjuJJ28XQ9ycINrfZXGdJVc0TKXCYbWtWrrL6B/t
2wE7eQgbauGoQjlFpOgUsI85FnhC2kBb/S4RiVsCgYEA2StEFc4VuFB+faYLVN/P
UgEUAJ17YmwjGBoK7aaTZcgXcG4B9IBuXZdim4cuZqL/Kmd7Kvcu6oQIRGnZnJcE
Ej+cE7BynkZdA/rkXM7Ri3+0JjrSFrCjl2xz+VfUNk4X+nfDpXHQTANMksYn1Z2s
cXjYHvc5x5yfOD7BQeXkCQcCgYBQYOrVwVYN/XxOiHBfssQHoGMfxOydeuy/AvrF
iYHCt7evLG/UTDebp7YoisQGO1YBmh5hD4Ik4ZMdTgpFjfL7nhGw1TvzdNLEUX5L
OtGMXwgibyWnbkD5XwebbEcRosDVWgqdVIqdp3BIt3EmwS7Oho4lrIZVZkToQCOk
NnML/QKBgQCLpvROvYOrzZkPU2C95h7W26Ia4rEDf0qgoAkK+gANN3McjcvZZWcR
wIyA3T94+j+WS/SmBsmJVS9tL2u0qDU/8ZrgSIZ5rmMOVRZ0WDcuRV/U9Ta3l2Bh
AT/Wf6+jxfJkQ7hWfRoGXgXjvpIu8QqL8QXMwPlPsylrGIgTUgDpCg==
-----END RSA PRIVATE KEY-----`

	rsa256PubPem = `-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwhFAG3EYPAOxg/B6LkVn
3ZV00otGud+DFYX8SsZOgW77dkVHr195YVazBdePgPahttA8R+dpXLrn3lBAKxqG
8uzgkPQ7Tis1vIRxha5ZMxE2rKBqxfcB7xMbsV6c7ozlX1fT7uS1ZajJQrvjN8Jj
fK0U3As1zx7E3wzcheRn4FbviBseqkwpDLRxm3g7n+T+iXsddi37xC7o7qSCmivW
+RIou3xXfZcoVRB38lOAzNytF+bqz1jkN0Lp3iw0unMYt07ZoOlyKh5IEXKdMlAl
7UURgreSqSfBv+E87Xq34T17UK+YA87F3dxLW40rsfynU5BzUgWDPDy09SSCE4XZ
iQIDAQAB
-----END PUBLIC KEY-----`
)
