package utils

import (
	"math"
	"time"
)

const maxRetryLimit = 5

// WithRetry is to retry function for a certain times using Exponential backoff strategy
// using this will block the current go routine
// so it's better to be used in goroutines other than the main routine
func WithRetry(f func() error, retryLimit int) error {
	var failureCount = 0
	var err = f()
	for failureCount < retryLimit && failureCount < maxRetryLimit && err != nil {
		nextExecutionInSeconds := int64(math.Pow(2, float64(failureCount)) - 1)
		err = f()
		if err == nil || failureCount == retryLimit || failureCount == maxRetryLimit {
			return err
		}
		failureCount = failureCount + 1
		time.Sleep(time.Duration(nextExecutionInSeconds) * time.Second)
	}
	return err
}
