import javaposse.jobdsl.dsl.helpers.step.*

job {
    name "twitch-rbac-build"
    using 'TEMPLATE-autobuild'
    wrappers {
        credentialsBinding {
            string 'STAGING_AWS_ACCESS_KEY', 'twitch-rbac-dev-id'
            string 'STAGING_AWS_SECRET_KEY', 'twitch-rbac-dev-secret'
            string 'PROD_AWS_ACCESS_KEY', 'twitch-rbac-prod-id'
            string 'PROD_AWS_SECRET_KEY', 'twitch-rbac-prod-secret'
            string 'JOB_DSL_SEED',   'job-dsl-seed'
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }
    scm {
        git {
            remote {
                github 'devrel/devsite-rbac', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    // Bundle application version to store in S3 for Elastic Beanstalk
    steps {
        shell 'make ci'
        shell 'echo "updating staging bundle"'
        shell "cp config/*-staging.config .ebextensions/"
        shell """zip -r \$GIT_COMMIT.zip .ebextensions Procfile config/env-staging.toml rbac"""
        // Unable to use uploadBeanstalkBundle because it's too opinionated about environment variables
        shell """
        set +x
        export AWS_ACCESS_KEY_ID=\$STAGING_AWS_ACCESS_KEY
        export AWS_SECRET_ACCESS_KEY=\$STAGING_AWS_SECRET_KEY
        set -x
        export AWS_DEFAULT_REGION=us-west-2
        export BUCKET=twitch-rbac-dev
        export APP_NAME=staging-devsite-rbac
        description=`git log --pretty=format:"%an - %ad: %s" --abbrev-commit -1 | cut -c 1-200`
        aws s3 cp \$GIT_COMMIT.zip s3://\$BUCKET/apps/\$APP_NAME/\$GIT_COMMIT.zip
        aws elasticbeanstalk create-application-version --no-auto-create-application --application-name \$APP_NAME --version-label \$GIT_COMMIT --description "\$description" --source-bundle S3Bucket=\$BUCKET,S3Key=apps/\$APP_NAME/\$GIT_COMMIT.zip
        """
        shell "rm \$GIT_COMMIT.zip"
        shell 'echo "updating production bundle"'
        shell "rm .ebextensions/*-staging.config"
        shell "cp config/*-production.config .ebextensions/"
        shell """zip -r \$GIT_COMMIT.zip .ebextensions Procfile config/env-production.toml rbac"""
        shell """
        set +x
        export AWS_ACCESS_KEY_ID=\$PROD_AWS_ACCESS_KEY
        export AWS_SECRET_ACCESS_KEY=\$PROD_AWS_SECRET_KEY
        set -x
        export AWS_DEFAULT_REGION=us-west-2
        export BUCKET=twitch-rbac-prod
        export APP_NAME=prod-devsite-rbac
        description=`git log --pretty=format:"%an - %ad: %s" --abbrev-commit -1 | cut -c 1-200`
        aws s3 cp \$GIT_COMMIT.zip s3://\$BUCKET/apps/\$APP_NAME/\$GIT_COMMIT.zip
        aws elasticbeanstalk create-application-version --no-auto-create-application --application-name \$APP_NAME --version-label \$GIT_COMMIT --description "\$description" --source-bundle S3Bucket=\$BUCKET,S3Key=apps/\$APP_NAME/\$GIT_COMMIT.zip
        """
    }

    // Set build status on github
    publishers {
        reportQuality('devrel/devsite-rbac', '.', 'coverfile.out', '', '-F unit')
        reportQuality('devrel/devsite-rbac', '.', 'coverfile_e2e.out', '', '-F e2e')
        githubCommitNotifier()
    }
}

[staging: [
    access_key: "twitch-rbac-dev-id",
    secret_key: "twitch-rbac-dev-secret",
    bucket: "twitch-rbac-dev",
    config: "staging",
],
prod: [
    access_key: "twitch-rbac-prod-id",
    secret_key: "twitch-rbac-prod-secret",
    bucket: "twitch-rbac-prod",
    config: "production"
]].each{ ENVIRONMENT, VALUES ->
    job {
        name "devrel-devsite-rbac-${ENVIRONMENT}-deploy"
        using 'TEMPLATE-deploy-aws'
        wrappers {
            credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', "${VALUES.access_key}"
            string 'AWS_SECRET_KEY', "${VALUES.secret_key}"
            }
        }

        steps {
            shell """
echo "Deploying to us-west-2\n"
export AWS_ACCESS_KEY_ID=\${AWS_ACCESS_KEY}
export AWS_SECRET_ACCESS_KEY=\${AWS_SECRET_KEY}
export AWS_DEFAULT_REGION=us-west-2
export PYTHONUNBUFFERED=1
mkdir .elasticbeanstalk
cat  <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: ${ENVIRONMENT}-devsite-rbac
  default_region: us-west-2
option_settings:
  - namespace: aws:elasticbeanstalk:command
    option_name: Timeout
    value: 1800
EOF
eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
eb deploy ${ENVIRONMENT}-devsite-rbac-server --version \${GIT_COMMIT} --timeout 20
rm .elasticbeanstalk/config.yml
rmdir .elasticbeanstalk"""
        }
    }
}

