CREATE TABLE public.memberships (
    twitch_id character varying(50) NOT NULL,
    company_id uuid NOT NULL,
    role text NOT NULL,
    first_name character varying(64) NOT NULL,
    last_name character varying(64) NOT NULL,
    dev_title character varying(64) DEFAULT ''::character varying NOT NULL,
    dev_email character varying(64) NOT NULL,
    created_at timestamp without time zone NOT NULL,
    modified_at timestamp without time zone,

    PRIMARY KEY (company_id, twitch_id),
    FOREIGN KEY (company_id) REFERENCES public.companies(id)
);

ALTER TABLE public.memberships OWNER TO rbac;

CREATE INDEX ON public.memberships (twitch_id);
