package permissions

//
// Resources
//
const (
	Extension = "extension"
	Game      = "game"
	Company   = "company"
	User      = "user"
)

//
// Permissions
//
const (
	// Company
	EditCompanyInfo       = "editCompanyInfo"
	ShowCompanyMembers    = "showCompanyMembers"
	AddUser               = "addUser"
	AddUserBillingManager = "addUser::Billing_Manager"
	RemoveUser            = "removeUser"
	AssignPermissions     = "assignPermissions"

	// User
	ViewPaymentOnboarding = "viewPaymentOnboarding" // Can see payment onboarding status of another user

	// Drops (NOTE: ResourceType is "company", not drops)
	// Used mainly from the CreateJWT endpoint for the VHS service.
	ViewDrops          = "drops::view"
	CreateDrops        = "drops::create"
	ManageDrops        = "drops::manage"
	DeleteDrops        = "drops::delete"
	DropsAnalyticsView = "drops::analytics::view"

	// Insights
	InsightsOnePagerView = "insights-1pager::view"

	// Game
	AddGames          = "gamesAdd"
	GameAnalyticsView = "games::analytics::view"
	GameBoxArtEdit    = "games::boxart::edit"
	ViewGame          = "games::view"

	// Extension
	CreateExtensions      = "extensions::create"
	ManageExtensions      = "extensions::manage"
	MonetizeExtensions    = "extensions::monetize"
	ViewExtensionInsights = "extensions::insights"
	SetBillingManager     = "extensions::setBillingManager" // can assign extension billing managers
)
