# Extension Reviews

The ExtensionReviews service handles the review lifecycle of Extensions. Responsabilities:

 * Wraps EMS (Extensions Service) on the state transitions to "review", "approved" and "pending_action".
 * Integrates with Salesforce, creates Cases that are used by moderators to manage the reviews and communicate with the developers.
 * Keeps track of state changes (ExtensionStateChangeLogs).
 * Manages the developer's notes and test channel, used when the extension version is set in review. EMS does not store this values.

The service has two types of users:

 * Developers (end users): set the extension version in review from Twilight, through the GraphQL edge which authenticates using Cartman and adds a Twitch-Authorization header to the request. This header is used to have access to the extension in EMS.
 * Reviewers (twitch moderators): expect to find the extension case in Salesforce, but then go to Vienna to approve it or mark it as pending action. These requests have an OAuth token, but have not been signed by Carman yet, RBAC has to do that in order to have access to the extension in EMS.

![Architecture Diagram](ArchitectureDiagram.jpg)
