package extensionreviewsserver

import (
	"testing"

	"github.com/stretchr/testify/require"
	"github.com/twitchtv/twirp"

	"code.justin.tv/devrel/devsite-rbac/backend/extensionreviewlogs/extensionreviewlogsfakes"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/devrel/devsite-rbac/rpc/testutil"
)

func TestGetLatestAuthorNotes_Success(t *testing.T) {
	server, _ := NewTestServer()
	dbReviewLogs := server.DBExtensionReviewLogs.(*extensionreviewlogsfakes.FakeExtensionReviewLogs)
	dbReviewLogs.GetLastWithAuthorNotesReturns(&rbacrpc.ExtensionReviewLog{
		AuthorNotes:   "Blah Blah Author Notes",
		AuthorChannel: "twitch/mychannel",
	}, nil)

	latestLog, err := server.GetLatestAuthorNotes(ctx, &rbacrpc.GetLatestAuthorNotesRequest{
		AuthorTwitchId: "322",
		ExtensionId:    "abc",
	})
	require.NoError(t, err)
	require.Equal(t, "Blah Blah Author Notes", latestLog.AuthorNotes)
	require.Equal(t, "twitch/mychannel", latestLog.AuthorChannel)
}

func TestGetLatestAuthorNotes_NotFound(t *testing.T) {
	server, _ := NewTestServer()

	_, err := server.GetLatestAuthorNotes(ctx, &rbacrpc.GetLatestAuthorNotesRequest{
		AuthorTwitchId: "322",
		ExtensionId:    "abc",
	})
	testutil.EqualErrorCode(t, twirp.NotFound, err)
}
