package extensionreviewsserver

import (
	"fmt"

	"github.com/twitchtv/twirp"
	"goji.io/pat"

	"code.justin.tv/devrel/devsite-rbac/backend/extensionreviewlogs"
	"code.justin.tv/devrel/devsite-rbac/clients/cartman"
	"code.justin.tv/devrel/devsite-rbac/clients/extensions"
	"code.justin.tv/devrel/devsite-rbac/clients/salesforce"
	"code.justin.tv/devrel/devsite-rbac/clients/users"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/devrel/devsite-rbac/rpc/server"
)

type Server struct {
	Salesforce            salesforce.Client
	Extensions            extensions.Client
	Cartman               cartman.Client
	Users                 users.Users
	DBExtensionReviewLogs extensionreviewlogs.ExtensionReviewLogs
}

func New(srv *Server, hooks *twirp.ServerHooks) *server.Route {
	handler := rbacrpc.NewExtensionReviewsServer(srv, hooks)
	return &server.Route{
		Pattern: pat.Post(fmt.Sprintf("%s*", rbacrpc.ExtensionReviewsPathPrefix)),
		Handler: handler,
	}
}
