package extensionreviewsserver

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/require"

	"code.justin.tv/devrel/devsite-rbac/backend/extensionreviewlogs/extensionreviewlogsfakes"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/foundation/twitchclient"
)

func TestSetStatePendingAction_Success(t *testing.T) {
	server, _ := NewTestServer()

	_, err := server.SetStatePendingAction(ctxWithTwitchID, newSetStateReviewerRequest())
	require.NoError(t, err)
}

func TestSetStatePendingAction_ValidatesParams(t *testing.T) {
	var err error
	server, _ := NewTestServer()

	_, err = server.SetStatePendingAction(ctxWithTwitchID, &rbacrpc.SetStateReviewerRequest{})
	require.EqualError(t, err, "twirp error invalid_argument: extension_id is required")

	_, err = server.SetStatePendingAction(ctxWithTwitchID, &rbacrpc.SetStateReviewerRequest{ExtensionId: "fff"})
	require.EqualError(t, err, "twirp error invalid_argument: extension_version is required")
}

func TestSetStatePendingAction_RequiresAuthorizationHeader(t *testing.T) {
	server, _ := NewTestServer()

	_, err := server.SetStatePendingAction(ctx, newSetStateReviewerRequest())
	require.EqualError(t, err, "twirp error unauthenticated: Mising Authorization header with OAuth token")
}

func TestSetStatePendingAction_EMSStateTransitionError(t *testing.T) {
	server, extensions := NewTestServer()
	extensions.TransitionExtensionStateReturnsError = &twitchclient.Error{StatusCode: 500, Message: "oops"}

	_, err := server.SetStatePendingAction(ctxWithTwitchID, newSetStateReviewerRequest())
	require.EqualError(t, err, "twirp error internal: oops")
}

func TestSetStatePendingAction_IgnoresReviewLogsError(t *testing.T) {
	server, _ := NewTestServer()
	dbReviewLogs := server.DBExtensionReviewLogs.(*extensionreviewlogsfakes.FakeExtensionReviewLogs)
	dbReviewLogs.InsertReturns(errors.New("Ignore me"))

	_, err := server.SetStatePendingAction(ctxWithTwitchID, newSetStateReviewerRequest())
	require.NoError(t, err) // ignored
}
