package privacyserver

import (
	"code.justin.tv/devrel/devsite-rbac/clients/pdms"
	"fmt"

	"code.justin.tv/devrel/devsite-rbac/backend"
	"code.justin.tv/devrel/devsite-rbac/backend/actionhistories"
	"code.justin.tv/devrel/devsite-rbac/backend/developerapplications"
	"code.justin.tv/devrel/devsite-rbac/backend/memberships"
	"code.justin.tv/devrel/devsite-rbac/backend/viennauserwhitelist"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/devrel/devsite-rbac/rpc/server"
	"github.com/twitchtv/twirp"
	"goji.io/pat"
)

type Server struct {
	ApiKey				  string
	Backend               backend.Backender
	ActionHistories       actionhistories.ActionHistories
	Memberships           memberships.Memberships
	DeveloperApplications developerapplications.DeveloperApplications
	ViennaUserWhitelist   viennauserwhitelist.UserWhitelist
	PDMS				  pdms.PDMS
}

func New(srv *Server, hooks *twirp.ServerHooks) *server.Route {
	handler := rbacrpc.NewPrivacyServer(srv, hooks)
	return &server.Route{
		Pattern: pat.Post(fmt.Sprintf("%s*", rbacrpc.PrivacyPathPrefix)),
		Handler: handler,
	}
}
