package rbacactionhistoryserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/actionhistories"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) ListEntityActionHistories(ctx context.Context, params *rbacrpc.ListEntityActionHistoriesRequest) (*rbacrpc.ListActionHistoriesResponse, error) {
	if err := errorutil.ValidateRequiredArgs(errorutil.Args{
		{"entity_id", params.EntityId},
		{"entity_type", params.EntityType},
	}); err != nil {
		return nil, err
	}

	res, total, err := s.ActionHistories.ListActionHistories(ctx, actionhistories.ListParams{
		EntityID:   params.EntityId,
		EntityType: params.EntityType,
		Limit:      1000,
	})
	if err != nil {
		return nil, err
	}

	return &rbacrpc.ListActionHistoriesResponse{
		ActionHistories: res,
		Total:           total,
	}, nil
}

func (s *Server) ListActionHistories(ctx context.Context, params *rbacrpc.ListActionHistoriesRequest) (*rbacrpc.ListActionHistoriesResponse, error) {
	if params.Limit == 0 {
		params.Limit = 50
	}

	res, total, err := s.ActionHistories.ListActionHistories(ctx, actionhistories.ListParams{
		CompanyID:  params.CompanyId,
		EntityID:   params.EntityId,
		EntityType: params.EntityType,
		Limit:      params.Limit,
		Offset:     params.Offset,
	})
	if err != nil {
		return nil, err
	}

	return &rbacrpc.ListActionHistoriesResponse{
		ActionHistories: res,
		Total:           total,
	}, nil
}
