package rbacadminserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/auth"
	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"github.com/twitchtv/twirp"
)

// ValidateWhitelistAdmin validates if the caller is authorized to take actions on adding/removing/updating user
func (s *Server) ValidateWhitelistAdmin(ctx context.Context) error {
	if !auth.IsWhitelistAdmin(ctx) {
		return twirp.NewError(twirp.PermissionDenied, "User is unauthorized to take the action")
	}
	return nil
}

// isUserWhitelisted checks if a user is in the whitelist, for gating APIs used by Viennna
func (s *Server) isUserWhitelisted(ctx context.Context, userId string) (bool, error) {
	userWhitelist, err := s.ViennaUserWhitelist.GetWhitelistedUser(ctx, userId)
	if errorutil.IsErrNoRows(err) {
		return false, nil
	}
	if err != nil {
		return false, err
	}
	return userWhitelist.TwitchId != "", nil
}
