package rbacadminserver

import (
	"fmt"

	"code.justin.tv/devrel/devsite-rbac/backend"
	"code.justin.tv/devrel/devsite-rbac/backend/actionhistories"
	"code.justin.tv/devrel/devsite-rbac/backend/companyinvites"
	"code.justin.tv/devrel/devsite-rbac/backend/featuregating"
	"code.justin.tv/devrel/devsite-rbac/backend/memberships"
	"code.justin.tv/devrel/devsite-rbac/backend/viennauserwhitelist"
	"code.justin.tv/devrel/devsite-rbac/clients/channels_client"
	"code.justin.tv/devrel/devsite-rbac/clients/clue"
	"code.justin.tv/devrel/devsite-rbac/clients/nioh"
	"code.justin.tv/devrel/devsite-rbac/clients/passport"
	"code.justin.tv/devrel/devsite-rbac/clients/users"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/devrel/devsite-rbac/rpc/server"

	"github.com/twitchtv/twirp"
	"goji.io/pat"
)

type Server struct {
	Backend             backend.Backender
	ActionHistories     actionhistories.ActionHistories
	ViennaUserWhitelist viennauserwhitelist.UserWhitelist
	FeatureGating       featuregating.FeatureGating
	Memberships         memberships.Memberships
	CompanyInvites      companyinvites.CompanyInvites
	Users               users.Users
	Channels            channels_client.Channels
	Clue                clue.Clue
	Nioh                nioh.Nioh
	Passport            passport.Client
}

func New(srv *Server, hooks *twirp.ServerHooks) *server.Route {
	handler := rbacrpc.NewRBACAdminServer(srv, hooks)
	return &server.Route{
		Pattern: pat.Post(fmt.Sprintf("%s*", rbacrpc.RBACAdminPathPrefix)),
		Handler: handler,
	}
}
