package rbacadminserver

import (
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
	"golang.org/x/net/context"
)

func (s *Server) WhitelistUser(ctx context.Context, params *rbacrpc.WhitelistUserRequest) (*rbacrpc.Empty, error) {
	err := s.ValidateWhitelistAdmin(ctx)
	if err != nil {
		return nil, err
	}
	isUserWhitelised, err := s.isUserWhitelisted(ctx, params.TwitchId)
	if err != nil {
		return nil, err
	}
	if isUserWhitelised {
		return nil, twirp.NewError(twirp.AlreadyExists, "The user has already been whitelisted.")
	}
	err = s.ViennaUserWhitelist.WhitelistUser(ctx, params)
	return &rbacrpc.Empty{}, err
}

func (s *Server) RemoveUserFromWhitelist(ctx context.Context, params *rbacrpc.RemoveUserFromWhitelistRequest) (*rbacrpc.Empty, error) {
	err := s.ValidateWhitelistAdmin(ctx)
	if err != nil {
		return nil, err
	}
	isUserWhitelised, err := s.isUserWhitelisted(ctx, params.TwitchId)
	if err != nil {
		return nil, err
	}
	if !isUserWhitelised {
		return nil, twirp.NewError(twirp.InvalidArgument, "The user is not in the whitelist")
	}
	err = s.ViennaUserWhitelist.RemoveUserFromWhitelist(ctx, params)
	return &rbacrpc.Empty{}, err
}

func (s *Server) UpdateUserRoleInWhitelist(ctx context.Context, params *rbacrpc.WhitelistUserRequest) (*rbacrpc.Empty, error) {
	err := s.ValidateWhitelistAdmin(ctx)
	if err != nil {
		return nil, err
	}
	isUserWhitelised, err := s.isUserWhitelisted(ctx, params.TwitchId)
	if err != nil {
		return nil, err
	}
	if !isUserWhitelised {
		return nil, twirp.NewError(twirp.InvalidArgument, "The user is not in the whitelist")
	}
	err = s.ViennaUserWhitelist.UpdateUserRoleInWhitelist(ctx, params)
	return &rbacrpc.Empty{}, err
}

func (s *Server) ListUserWhitelistByRole(ctx context.Context, params *rbacrpc.ListUserWhitelistByRoleRequest) (*rbacrpc.ListUserWhitelistByRoleResponse, error) {
	return s.ViennaUserWhitelist.ListUserWhitelistByRole(ctx, params)
}
