package rbacrpcserver

import (
	"strconv"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"context"
)

func (s *Server) GetAllGamesWithCompanies(ctx context.Context, params *rbacrpc.GetAllGamesWithCompaniesRequest) (*rbacrpc.GetAllGamesWithCompaniesResponse, error) {
	if params.Limit == 0 {
		params.Limit = 10
	}

	gameResources, total, err := s.Backend.FindResources(ctx, "", "game", "", params.Limit, params.Offset)
	if err != nil {
		return nil, err
	}

	companyByGameID := make(map[string]*rbacrpc.Company)
	externalIDsAsStrings := make([]string, len(gameResources))
	for i, gameResource := range gameResources {
		externalIDsAsStrings[i] = gameResource.ExternalId

		if _, ok := companyByGameID[gameResource.ExternalId]; ok {
			continue
		}

		company, err := s.Backend.SelectCompany(ctx, gameResource.CompanyID)
		if err != nil {
			return nil, err
		}
		companyByGameID[gameResource.ExternalId] = company
	}

	gamesResp, err := s.Discovery.GetAll(ctx, externalIDsAsStrings)
	if err != nil {
		return nil, err
	}

	games := []*rbacrpc.GameWithCompany{}
	for gameID, gameData := range gamesResp {
		id, err := strconv.ParseInt(gameID, 10, 32)
		if err != nil {
			return nil, err
		}
		gameWithCompany := &rbacrpc.GameWithCompany{
			Id:             int32(id),
			GiantbombId:    int32(gameData.Game.GiantbombID),
			CompanyId:      companyByGameID[gameID].Id,
			CurseCompanyId: int32(companyByGameID[gameID].CurseCompanyId),
			Gamename:       gameData.Game.Name,
			Legacy:         companyByGameID[gameID].Legacy,
		}
		games = append(games, gameWithCompany)
	}

	return &rbacrpc.GetAllGamesWithCompaniesResponse{XTotal: int32(total), Games: games}, nil
}
