package rbacrpcserver

import (
	"context"

	"github.com/twitchtv/twirp"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) GetCompany(ctx context.Context, id *rbacrpc.Id) (*rbacrpc.Company, error) {
	if err := errorutil.ValidateUUID("id", id.Id); err != nil {
		return nil, err
	}

	company, err := s.Backend.SelectCompany(ctx, id.Id)
	if errorutil.IsErrNoRows(err) {
		return nil, twirp.NotFoundError("not_found")
	}
	if err != nil {
		return nil, err
	}
	return company, nil
}
