package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) GetCompanyInvitesByTwitchID(ctx context.Context, params *rbacrpc.GetCompanyInvitesByTwitchIDRequest) (*rbacrpc.GetCompanyInvitesByTwitchIDResponse, error) {
	if params.Limit == 0 {
		params.Limit = 10
	}
	invites, total, err := s.Backend.SelectComanyInvitesByInviteeTwitchId(ctx, params.TwitchId, params.Limit, params.Offset)
	if err != nil {
		return nil, err
	}
	if len(invites) == 0 {
		return &rbacrpc.GetCompanyInvitesByTwitchIDResponse{}, nil
	}

	return &rbacrpc.GetCompanyInvitesByTwitchIDResponse{
		CompanyInvites: invites,
		XTotal:         total,
	}, nil
}
