package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/developerapplications"
	"code.justin.tv/devrel/devsite-rbac/internal/auth"
	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) GetDeveloperApplications(ctx context.Context, params *rbacrpc.GetDeveloperApplicationsRequest) (*rbacrpc.GetDeveloperApplicationsResponse, error) {
	if params.Limit == 0 {
		params.Limit = 10
	}
	if params.CompanyId != "" {
		if err := errorutil.ValidateUUID("company_id", params.CompanyId); err != nil {
			return nil, err
		}
	}

	devApps, err := s.DevApps.ListDeveloperApplications(ctx, developerapplications.ListDeveloperApplicationsParams{
		CompanyID: params.CompanyId,
		Limit:     params.Limit,
		Offset:    params.Offset,
	})
	if err != nil {
		return nil, err
	}
	if len(devApps) == 0 {
		return &rbacrpc.GetDeveloperApplicationsResponse{}, nil
	}
	rpcDevApps := developerapplications.ListToRPC(devApps)
	for _, devapp := range rpcDevApps {
		FilterSecureDataDeveloperApplication(ctx, devapp)
	}

	return &rbacrpc.GetDeveloperApplicationsResponse{
		DeveloperApplications: rpcDevApps,
		XTotal:                int32(len(rpcDevApps)),
	}, nil
}

//
// Helpers
//

func FilterSecureDataDeveloperApplication(ctx context.Context, devapp *rbacrpc.DeveloperApplication) {
	if auth.IsUserSecure(ctx) {
		return // is vienna super-admin, or not a vienna request
	}
	devapp.FirstName = ""
	devapp.LastName = ""
	devapp.Email = ""
}
