package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) GetGameApplication(ctx context.Context, id *rbacrpc.Id) (*rbacrpc.GameApplication, error) {
	if err := errorutil.ValidateUUID("id", id.Id); err != nil {
		return nil, err
	}

	gameApplication, err := s.Backend.SelectGameApplication(ctx, id.Id)
	if errorutil.IsErrNoRows(err) {
		return nil, twirp.NotFoundError("not_found")
	}
	if err != nil {
		return nil, err
	}

	return gameApplication, nil
}
