package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/auth"
	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) GetMembership(ctx context.Context, params *rbacrpc.GetMembershipRequest) (*rbacrpc.Membership, error) {
	if auth.IsWhitelistAdmin(ctx) {
		params.RequestingTwitchId = auth.GetTwitchID(ctx)
	}
	if err := errorutil.ValidateRequiredArgs(errorutil.Args{
		{"company_id", params.CompanyId},
		{"twitch_id", params.TwitchId},
		{"requesting_twitch_id", params.RequestingTwitchId},
	}); err != nil {
		return nil, err
	}

	if err := errorutil.ValidateUUID("company_id", params.CompanyId); err != nil {
		return nil, err
	}

	memb, err := s.Memberships.GetMembership(ctx, params.CompanyId, params.TwitchId)
	if errorutil.IsErrNoRows(err) {
		return nil, twirp.NotFoundError("Membership not found")
	}
	if err != nil {
		return nil, err
	}

	rpcMemb := memb.ToRPC()
	FilterSecureData(ctx, rpcMemb) // hide unsecure fields if request has OAuth token
	return rpcMemb, nil
}

//
// Helpers
//

func FilterSecureData(ctx context.Context, memb *rbacrpc.Membership) {
	if auth.IsUserSecure(ctx) {
		return
	}

	memb.FirstName = ""
	memb.LastName = ""
	memb.DevEmail = ""
}
