package rbacrpcserver

import (
	"fmt"

	"context"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

var (
	defaultListGameApplicationsLimit uint64 = 10
)

func (s *Server) ListGameApplications(ctx context.Context, params *rbacrpc.ListGameApplicationsRequest) (*rbacrpc.ListGameApplicationsResponse, error) {
	limit := params.GetLimit()
	if limit == 0 {
		params.Limit = defaultListGameApplicationsLimit
	}

	res, err := s.Backend.FindGameApplications(ctx, params)
	if err != nil {
		return nil, err
	}

	s.addGameNameToGameApplications(ctx, res.GameApplications)

	return res, nil
}

func (s *Server) addGameNameToGameApplications(ctx context.Context, gameApps []*rbacrpc.GameApplication) {
	gameIDs := make([]string, len(gameApps))
	for i, gameApp := range gameApps {
		gameIDs[i] = fmt.Sprintf("%d", gameApp.GameId)
	}
	games, err := s.Discovery.GetAll(ctx, gameIDs)
	if err == nil {
		for i := range gameApps {
			game := games[fmt.Sprintf("%d", gameApps[i].GameId)]
			if game == nil {
				continue
			}
			gameApps[i].GameName = game.Name
		}
	}
}
