package rbacrpcserver

import (
	"context"

	"github.com/twitchtv/twirp"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) ListResources(ctx context.Context, params *rbacrpc.ListResourcesRequest) (*rbacrpc.ListResourcesResponse, error) {
	if params.Limit == 0 {
		params.Limit = 10
	}

	// Externally this should only be used to get company resources
	if params.CompanyId == "" {
		return nil, twirp.RequiredArgumentError("company_id")
	}
	if err := errorutil.ValidateUUID("company_id", params.CompanyId); err != nil {
		return nil, err
	}

	resourceTypes, total, err := s.Backend.FindResources(ctx, params.CompanyId, params.ResourceType, "", params.Limit, params.Offset)

	resources := make([]*rbacrpc.Resource, len(resourceTypes))
	for i, resourceType := range resourceTypes {
		resources[i] = resourceType.ToRPC()
	}

	return &rbacrpc.ListResourcesResponse{
		Resources: resources,
		XTotal:    uint64(total),
	}, err
}
