package rbacrpcserver

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/stretchr/testify/assert"
)

func TestSearchCompaniesSuccess(t *testing.T) {
	query := "test"
	var limit uint64 = 10
	params := &rbacrpc.SearchCompaniesRequest{
		Query: query,
		Limit: limit,
	}
	resp := &rbacrpc.SearchCompaniesResponse{}
	server, backend := NewTestServer()
	ctx := context.Background()
	backend.SearchCompaniesReturns(resp, nil)
	res, err := server.SearchCompanies(ctx, params)
	assert.Nil(t, err, "should not return error")
	assert.Equal(t, resp, res, "should return empty result")
}

func TestSearchCompaniesFailure(t *testing.T) {
	query := "test"
	var limit uint64 = 10
	params := &rbacrpc.SearchCompaniesRequest{
		Query: query,
		Limit: limit,
	}
	server, backend := NewTestServer()
	ctx := context.Background()
	failErr := errors.New("yas")
	backend.SearchCompaniesReturns(nil, failErr)
	resp, err := server.SearchCompanies(ctx, params)
	assert.Nil(t, resp, "should be nil")
	assert.Equal(t, failErr, err, "should be failErr")
}

func TestSearchCompaniesBadRequest(t *testing.T) {
	query := ""
	var limit uint64 = 10
	params := &rbacrpc.SearchCompaniesRequest{
		Query: query,
		Limit: limit,
	}
	server, _ := NewTestServer()
	ctx := context.Background()
	resp, err := server.SearchCompanies(ctx, params)
	assert.Nil(t, resp, "should be nil")
	assert.NotNil(t, err, "should be bad request error")
}
