package rbacrpcserver

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/devrel/devsite-rbac/backend/companyapplications"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/devrel/devsite-rbac/rpc/testutil"
	"github.com/stretchr/testify/assert"
	"github.com/twitchtv/twirp"
)

func TestSearchCompanyApplicationsSuccess(t *testing.T) {
	params := &rbacrpc.SearchCompanyApplicationsRequest{
		Query: "test",
		Limit: 10,
	}
	server, backend := NewTestServer()
	ctx := context.Background()
	backend.SearchCompanyApplicationsReturns([]companyapplications.CompanyApplication{}, 0, nil)
	res, err := server.SearchCompanyApplications(ctx, params)
	assert.NoError(t, err)
	assert.Empty(t, res.CompanyApplications)
	assert.Equal(t, res.XTotal, int32(0))
}

func TestSearchCompanyApplicationsFailure(t *testing.T) {
	params := &rbacrpc.SearchCompanyApplicationsRequest{
		Query: "test",
		Limit: 10,
	}
	server, backend := NewTestServer()
	ctx := context.Background()
	failErr := errors.New("yas")
	backend.SearchCompanyApplicationsReturns(nil, 0, failErr)
	resp, err := server.SearchCompanyApplications(ctx, params)
	assert.Nil(t, resp, "response should be nil")
	assert.Equal(t, failErr, err, "should be failErr")
}

func TestSearchCompanyApplicationsBadRequest(t *testing.T) {
	params := &rbacrpc.SearchCompanyApplicationsRequest{
		Query: "",
		Limit: 10,
	}
	server, _ := NewTestServer()
	ctx := context.Background()
	resp, err := server.SearchCompanyApplications(ctx, params)
	assert.Nil(t, resp, "should be nil")
	testutil.EqualErrorCode(t, twirp.InvalidArgument, err)
}
