package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/memberships"
)

const limit = 1000

func (s *Server) updateAllowedChattersByCompanyID(ctx context.Context, companyID string) error {
	memberships, _, err := s.Memberships.ListMemberships(ctx, memberships.ListMembershipsParams{
		CompanyID: companyID,
		Limit:     limit,
	})
	if err != nil {
		return err
	}

	var userIDs = make([]string, len(memberships))
	var shadowAccountIDs []string

	for idx, membership := range memberships {
		userIDs[idx] = membership.TwitchID
		if membership.Role == shadowAccountRole {
			shadowAccountIDs = append(shadowAccountIDs, membership.TwitchID)
		}
	}

	return s.Clue.UpdateAllowedChattersForChannels(ctx, userIDs, shadowAccountIDs)
}
