#!/bin/bash

echo "Make sure that twirp is not referenced on the DB/backend layer (only API methods should"
echo "This avoids unexpected 5xx errors when handling API errors in the middleware."

RESULTS=`grep -r './backend' -e 'twirp'`
EXIT_CODE=$?

if [ $EXIT_CODE -eq 1 ]; then
	exit 0
else
	if [ $EXIT_CODE -eq 2 ]; then
		echo "Error occurred with grep:"
		echo $RESULTS
	fi
fi

# code should be 0. text was found

echo "${RESULTS}" | awk '{print $1}' | sort -u |
echo "Don't use twirp package or errors on the db/backend layer, please handle that in the API method instead"
exit 1
