#!/usr/bin/env bash
set -e

#Update dev and production creds
ada credentials update --once --profile twitch-rbac-prod --account 712827439730 --role admin || (echo "===> ada failed: run mwinit <==" && exit 1)
ada credentials update --once --profile twitch-rbac-dev --account 059023621032 --role admin || (echo "===> ada failed: run mwinit <==" && exit 1)

echo 'Enter the name to be used for the new Snapshot'
read SNAPSHOT

echo 'Enter the name to be used for the new Datebase Intance EX: (rbac-staging-2020-04-03)'
read CLUSTER_NAME

DB_NAME=${CLUSTER_NAME}'-master'

#Get credientals for the production database instance
PROD_ADMIN_CREDS=$(aws secretsmanager get-secret-value --secret-id devsite/rbac/production/admin_db_rds --profile=twitch-rbac-prod --region=us-west-2 --query 'SecretString' --output text )
PROD_DB_INSTANCE=$(echo ${PROD_ADMIN_CREDS} | sed -n 's|.*"dbInstanceIdentifier":"\([^"]*\)".*|\1|p')
PROD_ADMIN_PASS=$(echo ${PROD_ADMIN_CREDS} | sed -n 's|.*"password":"\([^"]*\)".*|\1|p')
PROD_ADMIN_NAME=$(echo ${PROD_ADMIN_CREDS} | sed -n 's|.*"username":"\([^"]*\)".*|\1|p')

echo "Create Snapshot"
SNAPSTATUS=$(aws rds create-db-cluster-snapshot --profile=twitch-rbac-prod --region=us-west-2  \
		    --db-cluster-identifier ${PROD_DB_INSTANCE} \
		    --db-cluster-snapshot-identifier ${SNAPSHOT} \
		    --query 'DBClusterSnapshot.Status' --output text)

while [ "${SNAPSTATUS}" == "creating" ]
do
	echo "Waiting for snapshot to finish."
	sleep 30
	SNAPSTATUS=$(aws rds describe-db-cluster-snapshots --profile=twitch-rbac-prod --region=us-west-2 --db-cluster-snapshot-identifier ${SNAPSHOT} --query 'DBClusterSnapshots[0].Status' --output text)
done

echo "Sharing snapshot with staging account"
(aws rds modify-db-cluster-snapshot-attribute --profile=twitch-rbac-prod --region=us-west-2  \
    --db-cluster-snapshot-identifier ${SNAPSHOT} \
    --attribute-name restore \
    --values-to-add 059023621032 \
    --output text ) > /dev/null

echo "Finished snapshot"

SNAP_ARN=$(aws rds describe-db-cluster-snapshots --profile=twitch-rbac-prod --region=us-west-2 --db-cluster-snapshot-identifier ${SNAPSHOT} --query 'DBClusterSnapshots[0].DBClusterSnapshotArn' --output text)


echo "Starting cluster restore on Staging"

CLUSTER_STATUS=$(aws rds restore-db-cluster-from-snapshot --profile=twitch-rbac-dev --region=us-west-2 \
		--engine "aurora-postgresql" \
		--engine-version "11.4" \
		--db-cluster-identifier ${CLUSTER_NAME} \
		--snapshot-identifier ${SNAP_ARN} \
		--port 5433 \
		--db-subnet-group-name "rbac-staging-subnet" \
		--vpc-security-group-ids "sg-a70b9bdf" \
		--engine-mode "provisioned" \
		--query 'DBCluster.Status' --output text)


while [ "${CLUSTER_STATUS}" == "creating" ]
do
	echo "Waiting for cluster to finish."
	sleep 60
	CLUSTER_STATUS=$(aws rds describe-db-clusters --profile=twitch-rbac-dev --region=us-west-2 --db-cluster-identifier ${CLUSTER_NAME} --query 'DBClusters[0].Status' --output text)
done

echo "Starting writer database restore on cluster"

DB_STATUS=$(aws rds create-db-instance --profile=twitch-rbac-dev --region=us-west-2 \
		--engine "aurora-postgresql" \
		--engine-version "11.4" \
		--db-instance-identifier ${DB_NAME} \
		--db-instance-class "db.t3.medium" \
		--db-subnet-group-name "rbac-staging-subnet" \
		--db-cluster-identifier ${CLUSTER_NAME} \
		--query 'DBInstance.DBInstanceStatus' --output text)


while [ "${DB_STATUS}" == "creating" ]
do
	echo "Waiting for database to finish."
	sleep 60
	DB_STATUS=$(aws rds describe-db-instances --profile=twitch-rbac-dev --region=us-west-2 --db-instance-identifier ${DB_NAME}  --query 'DBInstances[0].DBInstanceStatus' --output text)
done

echo 'Getting staging passwords'

ADMIN_CREDS=$(aws secretsmanager get-secret-value --secret-id devsite/rbac/staging/admin_db_rds --profile=twitch-rbac-dev --region=us-west-2 --query 'SecretString' --output text)
ADMIN_PASS=$(echo ${ADMIN_CREDS} | sed -n 's|.*"password":"\([^"]*\)".*|\1|p')
ADMIN_NAME=$(echo ${ADMIN_CREDS} | sed -n 's|.*"username":"\([^"]*\)".*|\1|p')

USER_CREDS=$(aws secretsmanager get-secret-value --secret-id devsite/rbac/staging/db_rds --profile=twitch-rbac-dev --region=us-west-2 --query 'SecretString'  --output text )
USER_PASS=$(echo ${USER_CREDS} | sed -n 's|.*"password":"\([^"]*\)".*|\1|p')
USER_NAME=$(echo ${USER_CREDS} | sed -n 's|.*"username":"\([^"]*\)".*|\1|p')

CLUSTER_ENDPOINT=$(aws rds describe-db-clusters --profile=twitch-rbac-dev --region=us-west-2 --db-cluster-identifier ${CLUSTER_NAME} --query 'DBClusters[0].Endpoint' --output text)

echo 'Resetting staging db password'

PGPASSWORD=${PROD_ADMIN_PASS} \
psql -h ${CLUSTER_ENDPOINT} -p 5433 -U ${PROD_ADMIN_NAME} rbac  -c "ALTER USER ${USER_NAME} WITH ENCRYPTED PASSWORD '${USER_PASS}'"

PGPASSWORD=${PROD_ADMIN_PASS} \
psql -h ${CLUSTER_ENDPOINT} -p 5433 -U ${PROD_ADMIN_NAME} rbac  -c "ALTER USER ${ADMIN_NAME} WITH ENCRYPTED PASSWORD '${ADMIN_PASS}'"

echo 'Fin'
