//+build wireinject

package s2s2

import (
	"github.com/google/wire"
)

// New returns a new S2S2 client.
// Used by github.com/google/wire to generate ./wire_gen.go
func New(options *Options) (*S2S2, error) {
	wire.Build(
		// directly wired from options
		newConfigFromOptions,
		newCredentialsFromOptions,
		newLoggerFromOptions,
		newOperationStarterFromOptions,
		newRoundTripperFromOptions,
		// built from options outputs
		newAccessTokens,
		newAssertions,
		newAuthorizations,
		newOnTokenAuthenticatedHook,
		newOnTokenRejectedHook,
		newCachedAuthorizations,
		newClientCredentials,
		newClientServiceURI,
		newProvidedClientServiceURI,
		newHTTPClient,
		newOIDC,
		newOIDCCache,
		newSigV4HTTPClient,
		newSigV4RoundTripper,
		newS2S2,
		newServiceOrigins,
	)
	return nil, nil
}
