// Code generated by protoc-gen-twirp v5.6.0, DO NOT EDIT.
// source: clue.proto

/*
Package clue is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.6.0.

It is generated from these files:
	clue.proto
*/
package clue

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==============
// Clue Interface
// ==============

// The Clue service supports chat on Twitch.
type Clue interface {
	// GetMessageByID returns a message for an given id
	GetMessageByID(context.Context, *GetMessageByIDRequest) (*GetMessageByIDResponse, error)

	// ListMessageReplies returns a list of replies message ids to a given parent message id.
	ListMessageReplies(context.Context, *ListMessageRepliesRequest) (*ListMessageRepliesResponse, error)

	// SendSkipSubsModeMessage sends a chat message to a channel without checking the subscriber-only mode enforcement.
	// SLO@2s
	SendSkipSubsModeMessage(context.Context, *SendSkipSubsModeMessageRequest) (*SendSkipSubsModeMessageResponse, error)

	// SendHighlightedMessage sends a highlighted message to the channel.
	SendHighlightedMessage(context.Context, *SendHighlightedMessageRequest) (*SendHighlightedMessageResponse, error)

	// SendCustomRewardRedemptionMessage informs chat of a custom reward redemption in the channel.
	SendCustomRewardRedemptionMessage(context.Context, *SendCustomRewardRedemptionMessageRequest) (*SendCustomRewardRedemptionMessageResponse, error)

	// Set the list of allowed chatters of a channel.
	UpdateAllowedChatterIDs(context.Context, *UpdateAllowedChatterIDsRequest) (*UpdateAllowedChatterIDsResponse, error)

	// SendAllowedAutoModMessage is an endpoint to be used by the Automod service to submit an allowed message
	SendAllowedAutoModMessage(context.Context, *SendAllowedAutoModMessageRequest) (*SendAllowedAutoModMessageResponse, error)
}

// ====================
// Clue Protobuf Client
// ====================

type clueProtobufClient struct {
	client HTTPClient
	urls   [7]string
}

// NewClueProtobufClient creates a Protobuf client that implements the Clue interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewClueProtobufClient(addr string, client HTTPClient) Clue {
	prefix := urlBase(addr) + CluePathPrefix
	urls := [7]string{
		prefix + "GetMessageByID",
		prefix + "ListMessageReplies",
		prefix + "SendSkipSubsModeMessage",
		prefix + "SendHighlightedMessage",
		prefix + "SendCustomRewardRedemptionMessage",
		prefix + "UpdateAllowedChatterIDs",
		prefix + "SendAllowedAutoModMessage",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &clueProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &clueProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *clueProtobufClient) GetMessageByID(ctx context.Context, in *GetMessageByIDRequest) (*GetMessageByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "GetMessageByID")
	out := new(GetMessageByIDResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueProtobufClient) ListMessageReplies(ctx context.Context, in *ListMessageRepliesRequest) (*ListMessageRepliesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "ListMessageReplies")
	out := new(ListMessageRepliesResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueProtobufClient) SendSkipSubsModeMessage(ctx context.Context, in *SendSkipSubsModeMessageRequest) (*SendSkipSubsModeMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "SendSkipSubsModeMessage")
	out := new(SendSkipSubsModeMessageResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueProtobufClient) SendHighlightedMessage(ctx context.Context, in *SendHighlightedMessageRequest) (*SendHighlightedMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "SendHighlightedMessage")
	out := new(SendHighlightedMessageResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueProtobufClient) SendCustomRewardRedemptionMessage(ctx context.Context, in *SendCustomRewardRedemptionMessageRequest) (*SendCustomRewardRedemptionMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "SendCustomRewardRedemptionMessage")
	out := new(SendCustomRewardRedemptionMessageResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueProtobufClient) UpdateAllowedChatterIDs(ctx context.Context, in *UpdateAllowedChatterIDsRequest) (*UpdateAllowedChatterIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAllowedChatterIDs")
	out := new(UpdateAllowedChatterIDsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueProtobufClient) SendAllowedAutoModMessage(ctx context.Context, in *SendAllowedAutoModMessageRequest) (*SendAllowedAutoModMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "SendAllowedAutoModMessage")
	out := new(SendAllowedAutoModMessageResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ================
// Clue JSON Client
// ================

type clueJSONClient struct {
	client HTTPClient
	urls   [7]string
}

// NewClueJSONClient creates a JSON client that implements the Clue interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewClueJSONClient(addr string, client HTTPClient) Clue {
	prefix := urlBase(addr) + CluePathPrefix
	urls := [7]string{
		prefix + "GetMessageByID",
		prefix + "ListMessageReplies",
		prefix + "SendSkipSubsModeMessage",
		prefix + "SendHighlightedMessage",
		prefix + "SendCustomRewardRedemptionMessage",
		prefix + "UpdateAllowedChatterIDs",
		prefix + "SendAllowedAutoModMessage",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &clueJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &clueJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *clueJSONClient) GetMessageByID(ctx context.Context, in *GetMessageByIDRequest) (*GetMessageByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "GetMessageByID")
	out := new(GetMessageByIDResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueJSONClient) ListMessageReplies(ctx context.Context, in *ListMessageRepliesRequest) (*ListMessageRepliesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "ListMessageReplies")
	out := new(ListMessageRepliesResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueJSONClient) SendSkipSubsModeMessage(ctx context.Context, in *SendSkipSubsModeMessageRequest) (*SendSkipSubsModeMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "SendSkipSubsModeMessage")
	out := new(SendSkipSubsModeMessageResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueJSONClient) SendHighlightedMessage(ctx context.Context, in *SendHighlightedMessageRequest) (*SendHighlightedMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "SendHighlightedMessage")
	out := new(SendHighlightedMessageResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueJSONClient) SendCustomRewardRedemptionMessage(ctx context.Context, in *SendCustomRewardRedemptionMessageRequest) (*SendCustomRewardRedemptionMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "SendCustomRewardRedemptionMessage")
	out := new(SendCustomRewardRedemptionMessageResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueJSONClient) UpdateAllowedChatterIDs(ctx context.Context, in *UpdateAllowedChatterIDsRequest) (*UpdateAllowedChatterIDsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAllowedChatterIDs")
	out := new(UpdateAllowedChatterIDsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clueJSONClient) SendAllowedAutoModMessage(ctx context.Context, in *SendAllowedAutoModMessageRequest) (*SendAllowedAutoModMessageResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithMethodName(ctx, "SendAllowedAutoModMessage")
	out := new(SendAllowedAutoModMessageResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ===================
// Clue Server Handler
// ===================

type clueServer struct {
	Clue
	hooks *twirp.ServerHooks
}

func NewClueServer(svc Clue, hooks *twirp.ServerHooks) TwirpServer {
	return &clueServer{
		Clue:  svc,
		hooks: hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *clueServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// CluePathPrefix is used for all URL paths on a twirp Clue server.
// Requests are always: POST CluePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const CluePathPrefix = "/twirp/code.justin.tv.chat.clue.Clue/"

func (s *clueServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.chat.clue")
	ctx = ctxsetters.WithServiceName(ctx, "Clue")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.chat.clue.Clue/GetMessageByID":
		s.serveGetMessageByID(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.clue.Clue/ListMessageReplies":
		s.serveListMessageReplies(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.clue.Clue/SendSkipSubsModeMessage":
		s.serveSendSkipSubsModeMessage(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.clue.Clue/SendHighlightedMessage":
		s.serveSendHighlightedMessage(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.clue.Clue/SendCustomRewardRedemptionMessage":
		s.serveSendCustomRewardRedemptionMessage(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.clue.Clue/UpdateAllowedChatterIDs":
		s.serveUpdateAllowedChatterIDs(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.chat.clue.Clue/SendAllowedAutoModMessage":
		s.serveSendAllowedAutoModMessage(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *clueServer) serveGetMessageByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetMessageByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetMessageByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *clueServer) serveGetMessageByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetMessageByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetMessageByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetMessageByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.GetMessageByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetMessageByIDResponse and nil error while calling GetMessageByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveGetMessageByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetMessageByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetMessageByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetMessageByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.GetMessageByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetMessageByIDResponse and nil error while calling GetMessageByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveListMessageReplies(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListMessageRepliesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListMessageRepliesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *clueServer) serveListMessageRepliesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListMessageReplies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListMessageRepliesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListMessageRepliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.ListMessageReplies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListMessageRepliesResponse and nil error while calling ListMessageReplies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveListMessageRepliesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListMessageReplies")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListMessageRepliesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListMessageRepliesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.ListMessageReplies(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListMessageRepliesResponse and nil error while calling ListMessageReplies. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveSendSkipSubsModeMessage(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSendSkipSubsModeMessageJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendSkipSubsModeMessageProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *clueServer) serveSendSkipSubsModeMessageJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendSkipSubsModeMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SendSkipSubsModeMessageRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendSkipSubsModeMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.SendSkipSubsModeMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendSkipSubsModeMessageResponse and nil error while calling SendSkipSubsModeMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveSendSkipSubsModeMessageProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendSkipSubsModeMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendSkipSubsModeMessageRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendSkipSubsModeMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.SendSkipSubsModeMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendSkipSubsModeMessageResponse and nil error while calling SendSkipSubsModeMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveSendHighlightedMessage(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSendHighlightedMessageJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendHighlightedMessageProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *clueServer) serveSendHighlightedMessageJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendHighlightedMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SendHighlightedMessageRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendHighlightedMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.SendHighlightedMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendHighlightedMessageResponse and nil error while calling SendHighlightedMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveSendHighlightedMessageProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendHighlightedMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendHighlightedMessageRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendHighlightedMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.SendHighlightedMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendHighlightedMessageResponse and nil error while calling SendHighlightedMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveSendCustomRewardRedemptionMessage(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSendCustomRewardRedemptionMessageJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendCustomRewardRedemptionMessageProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *clueServer) serveSendCustomRewardRedemptionMessageJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendCustomRewardRedemptionMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SendCustomRewardRedemptionMessageRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendCustomRewardRedemptionMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.SendCustomRewardRedemptionMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendCustomRewardRedemptionMessageResponse and nil error while calling SendCustomRewardRedemptionMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveSendCustomRewardRedemptionMessageProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendCustomRewardRedemptionMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendCustomRewardRedemptionMessageRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendCustomRewardRedemptionMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.SendCustomRewardRedemptionMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendCustomRewardRedemptionMessageResponse and nil error while calling SendCustomRewardRedemptionMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveUpdateAllowedChatterIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateAllowedChatterIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateAllowedChatterIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *clueServer) serveUpdateAllowedChatterIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAllowedChatterIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateAllowedChatterIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateAllowedChatterIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.UpdateAllowedChatterIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAllowedChatterIDsResponse and nil error while calling UpdateAllowedChatterIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveUpdateAllowedChatterIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAllowedChatterIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateAllowedChatterIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateAllowedChatterIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.UpdateAllowedChatterIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAllowedChatterIDsResponse and nil error while calling UpdateAllowedChatterIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveSendAllowedAutoModMessage(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSendAllowedAutoModMessageJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendAllowedAutoModMessageProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *clueServer) serveSendAllowedAutoModMessageJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendAllowedAutoModMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SendAllowedAutoModMessageRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendAllowedAutoModMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.SendAllowedAutoModMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendAllowedAutoModMessageResponse and nil error while calling SendAllowedAutoModMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) serveSendAllowedAutoModMessageProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SendAllowedAutoModMessage")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendAllowedAutoModMessageRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendAllowedAutoModMessageResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Clue.SendAllowedAutoModMessage(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendAllowedAutoModMessageResponse and nil error while calling SendAllowedAutoModMessage. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *clueServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *clueServer) ProtocGenTwirpVersion() string {
	return "v5.6.0"
}

func (s *clueServer) PathPrefix() string {
	return CluePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.6.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1328 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xdf, 0x72, 0xd3, 0xc6,
	0x17, 0xfe, 0xc9, 0x49, 0xfc, 0xe7, 0x38, 0x71, 0xc4, 0x02, 0xc1, 0x98, 0x01, 0x12, 0xfd, 0x3a,
	0x25, 0x30, 0xad, 0xc3, 0x84, 0xfe, 0x81, 0x32, 0x9d, 0x8e, 0x2d, 0x89, 0xa0, 0xd6, 0xb6, 0x98,
	0x95, 0x5d, 0x86, 0xdc, 0xa8, 0x8a, 0xb5, 0x38, 0x2a, 0xb2, 0x56, 0x95, 0xd6, 0xd0, 0x5c, 0x75,
	0xa6, 0xb7, 0x9d, 0x72, 0xd5, 0xe9, 0x53, 0xb4, 0x77, 0xbd, 0xed, 0x1b, 0xf4, 0x69, 0xfa, 0x04,
	0x9d, 0x95, 0xd6, 0x26, 0x26, 0x96, 0x63, 0x68, 0xe8, 0x9d, 0x74, 0x74, 0xbe, 0xef, 0x7c, 0x7b,
	0xf6, 0xec, 0xd9, 0x63, 0x03, 0xf4, 0xfd, 0x11, 0xa9, 0x87, 0x11, 0x65, 0x14, 0x55, 0xfb, 0xd4,
	0x25, 0xf5, 0x6f, 0x47, 0x31, 0xf3, 0x82, 0x3a, 0x7b, 0x5e, 0xef, 0x1f, 0x3a, 0xac, 0xce, 0xbf,
	0xd7, 0xae, 0x0f, 0x28, 0x1d, 0xf8, 0x64, 0x27, 0xf1, 0x3b, 0x18, 0x3d, 0xdd, 0x61, 0xde, 0x90,
	0xc4, 0xcc, 0x19, 0x86, 0x29, 0x54, 0xf9, 0x04, 0x2e, 0xee, 0x11, 0xd6, 0x26, 0x71, 0xec, 0x0c,
	0x48, 0xf3, 0xc8, 0xd0, 0x30, 0xf9, 0x6e, 0x44, 0x62, 0x86, 0xae, 0x02, 0x0c, 0x53, 0xab, 0xed,
	0xb9, 0x55, 0x69, 0x53, 0xda, 0x2e, 0xe1, 0x92, 0xb0, 0x18, 0xae, 0xd2, 0x83, 0x8d, 0xd7, 0x71,
	0x71, 0x48, 0x83, 0x98, 0xa0, 0xfb, 0x50, 0x10, 0x6e, 0x09, 0xaa, 0xbc, 0xbb, 0x55, 0xcf, 0x92,
	0x57, 0x17, 0x78, 0x3c, 0x46, 0x28, 0x7b, 0x70, 0xb9, 0xe5, 0xc5, 0x63, 0x5e, 0x4c, 0x42, 0xdf,
	0x23, 0xf1, 0x58, 0xd2, 0x2d, 0x38, 0x17, 0x3a, 0x11, 0x09, 0x98, 0x7d, 0x42, 0xd9, 0x7a, 0xfa,
	0xa1, 0x3d, 0xd1, 0xf7, 0x04, 0x6a, 0xb3, 0x88, 0x5e, 0x69, 0x8c, 0x52, 0x53, 0x55, 0xda, 0x5c,
	0x5a, 0x50, 0xa3, 0x40, 0x28, 0x4f, 0xe1, 0x9a, 0x45, 0x02, 0xd7, 0x7a, 0xe6, 0x85, 0xd6, 0xe8,
	0x20, 0x6e, 0x53, 0x97, 0x4c, 0xc2, 0xa4, 0x42, 0x35, 0xc8, 0x87, 0x4e, 0xe4, 0x0c, 0x63, 0x91,
	0x81, 0x0f, 0xb2, 0xd9, 0x39, 0xd3, 0x34, 0x1a, 0x0b, 0xac, 0xe2, 0xc3, 0xf5, 0xcc, 0x38, 0x62,
	0x1d, 0x06, 0x14, 0x23, 0xf1, 0x2c, 0x42, 0x7d, 0xb8, 0x60, 0xa8, 0x14, 0x84, 0x27, 0x70, 0x85,
	0xc0, 0x55, 0xee, 0xf0, 0xd0, 0x1b, 0x1c, 0xfa, 0xde, 0xe0, 0x90, 0x11, 0xf7, 0x9d, 0x2c, 0xea,
	0x59, 0x9a, 0xbc, 0x59, 0x61, 0xce, 0x7e, 0x4d, 0xbf, 0x4b, 0xb0, 0xc9, 0x3d, 0x1a, 0xbe, 0x4f,
	0x5f, 0x10, 0xb7, 0x31, 0x62, 0xb4, 0x4d, 0xdf, 0xc9, 0xba, 0xd0, 0x15, 0x28, 0x45, 0xe4, 0x85,
	0x13, 0xb9, 0xbc, 0x26, 0x73, 0x49, 0x4d, 0x16, 0x53, 0x83, 0xe1, 0xa2, 0xf7, 0x61, 0x7d, 0x5c,
	0xb1, 0xec, 0x28, 0x4c, 0xca, 0x76, 0x29, 0x71, 0x59, 0x13, 0xe6, 0xee, 0x51, 0xc8, 0x8b, 0x36,
	0x80, 0xad, 0x39, 0x72, 0xcf, 0x3e, 0x3f, 0x3f, 0x4b, 0xb0, 0xcd, 0x3d, 0xd4, 0x51, 0xcc, 0xe8,
	0x10, 0x27, 0x72, 0x31, 0x71, 0xc9, 0x30, 0x64, 0x1e, 0x0d, 0xfe, 0xf3, 0x3c, 0x29, 0xcf, 0xe1,
	0xe6, 0x02, 0x72, 0xce, 0x3e, 0x0f, 0x14, 0xae, 0xf5, 0x42, 0xd7, 0x61, 0x44, 0x64, 0x5e, 0x3d,
	0x74, 0x18, 0x23, 0x91, 0xa1, 0xc5, 0xc7, 0xba, 0x61, 0xff, 0xd0, 0x09, 0x02, 0xe2, 0x1f, 0xeb,
	0x86, 0xc2, 0x62, 0xb8, 0xa8, 0x0e, 0xe7, 0x9d, 0x14, 0x6a, 0xf7, 0x53, 0xac, 0xed, 0xb9, 0x71,
	0x35, 0xb7, 0xb9, 0xb4, 0x5d, 0xc2, 0xe7, 0x9c, 0x69, 0x56, 0x37, 0x56, 0xbe, 0x81, 0xeb, 0x99,
	0x01, 0xc5, 0xf2, 0x3e, 0x87, 0x2b, 0xa3, 0xc4, 0xc5, 0xb5, 0x67, 0x51, 0x4b, 0x09, 0x75, 0x55,
	0xb8, 0x34, 0x4e, 0x44, 0x78, 0x99, 0x83, 0x82, 0x58, 0x30, 0xaa, 0x40, 0x6e, 0x22, 0x3a, 0xe7,
	0xb9, 0xe8, 0x0b, 0xc8, 0xc7, 0x24, 0x70, 0x49, 0x94, 0x6c, 0x40, 0x79, 0xf7, 0xc6, 0xa9, 0xcd,
	0xcf, 0x4a, 0xdc, 0xb1, 0x80, 0xa1, 0x26, 0x14, 0xfa, 0x34, 0x60, 0x24, 0x60, 0x49, 0x1d, 0x97,
	0x77, 0xb7, 0x4f, 0x65, 0x50, 0x53, 0x7f, 0x3c, 0x06, 0xa2, 0x3b, 0x50, 0x88, 0x79, 0x2b, 0x77,
	0x58, 0x75, 0x25, 0xe1, 0xa8, 0xd5, 0xd3, 0xbb, 0xaa, 0x3e, 0xbe, 0xab, 0xea, 0xdd, 0xf1, 0x5d,
	0x95, 0x04, 0x66, 0x0d, 0x86, 0xee, 0x01, 0xb8, 0xc4, 0x27, 0x49, 0x52, 0x58, 0x35, 0x7f, 0x2a,
	0xae, 0x24, 0xbc, 0x1b, 0x4c, 0x61, 0x50, 0x99, 0x96, 0x82, 0x10, 0x2c, 0x33, 0xf2, 0x3d, 0x13,
	0x89, 0x49, 0x9e, 0x51, 0x07, 0x4a, 0x4f, 0x23, 0x67, 0x30, 0x24, 0x01, 0x4b, 0xb7, 0xaf, 0xbc,
	0x7b, 0x7b, 0xd1, 0xb5, 0x3d, 0x10, 0x40, 0xfc, 0x8a, 0x42, 0xf9, 0x51, 0x82, 0x8d, 0xd9, 0x5e,
	0x33, 0xc3, 0x77, 0xa1, 0x48, 0x86, 0x94, 0x79, 0x7d, 0x1a, 0x88, 0xbd, 0xb9, 0xfb, 0xa6, 0xd1,
	0x75, 0x81, 0xc7, 0x13, 0x26, 0xe5, 0x4f, 0x09, 0xd6, 0xa6, 0x36, 0x12, 0x5d, 0x82, 0xc2, 0x28,
	0x4e, 0x2a, 0x49, 0x84, 0xcf, 0xf3, 0x57, 0xc3, 0x45, 0x17, 0x60, 0xc5, 0xa7, 0x03, 0x2f, 0x10,
	0x47, 0x33, 0x7d, 0x41, 0x5b, 0xb0, 0xea, 0x7a, 0x71, 0xe8, 0x3b, 0x47, 0x76, 0xe0, 0x0c, 0x89,
	0x68, 0x5e, 0x65, 0x61, 0xeb, 0x38, 0x43, 0x22, 0x0e, 0x08, 0xb3, 0xfb, 0xd4, 0xa7, 0x51, 0x75,
	0x79, 0x72, 0x40, 0x98, 0xca, 0x0d, 0xe8, 0x3e, 0xe4, 0x0f, 0x1c, 0x77, 0x40, 0xe2, 0xea, 0x4a,
	0x92, 0xd4, 0xff, 0x67, 0x2f, 0xab, 0x17, 0x93, 0xa8, 0xc9, 0x7d, 0xb1, 0x80, 0x28, 0x1f, 0x43,
	0x69, 0x62, 0x3c, 0x51, 0xcc, 0x55, 0x28, 0x3c, 0x27, 0x51, 0xec, 0xd1, 0xb1, 0xe6, 0xf1, 0x2b,
	0xbf, 0xa7, 0xe7, 0xa7, 0x08, 0x5d, 0x03, 0x18, 0x27, 0xc9, 0xd0, 0x04, 0xe7, 0x31, 0x0b, 0x7a,
	0x0f, 0xd6, 0xc6, 0x6f, 0x16, 0x61, 0x86, 0x26, 0x22, 0x4c, 0x1b, 0x95, 0x3f, 0x24, 0x40, 0x27,
	0x3b, 0x1e, 0xef, 0x74, 0xe9, 0x71, 0x79, 0x95, 0xe5, 0x62, 0x6a, 0x30, 0xdc, 0xd7, 0xfa, 0x49,
	0xee, 0xf5, 0x7e, 0xb2, 0x05, 0xab, 0x93, 0x0b, 0x83, 0xd7, 0x88, 0x48, 0xf8, 0xf8, 0xb6, 0xe0,
	0xa5, 0xc2, 0xf3, 0x10, 0x8a, 0x44, 0xe7, 0xbc, 0x10, 0x6d, 0x40, 0xde, 0xa7, 0x7d, 0xc7, 0x27,
	0xc9, 0x71, 0x2a, 0x61, 0xf1, 0xc6, 0xb7, 0xda, 0x8b, 0xed, 0x80, 0xd2, 0x30, 0x39, 0x2f, 0x45,
	0x9c, 0xf7, 0xe2, 0x0e, 0xa5, 0xa1, 0xf2, 0xab, 0x04, 0xe7, 0x67, 0xb4, 0x45, 0x01, 0xe0, 0x07,
	0x2e, 0x51, 0x9d, 0x00, 0x2c, 0x5e, 0xb0, 0xc7, 0x98, 0x72, 0xc7, 0x99, 0x50, 0x1b, 0x80, 0x44,
	0x11, 0x8d, 0x6c, 0xbe, 0xa7, 0x89, 0xd6, 0xca, 0x6e, 0x7d, 0xa1, 0x5e, 0xac, 0x73, 0x98, 0x4a,
	0x5d, 0x82, 0x4b, 0x64, 0xfc, 0x78, 0xeb, 0xaf, 0x1c, 0x5c, 0x98, 0xe5, 0x83, 0x56, 0xa1, 0xd8,
	0x31, 0x6d, 0x1d, 0x63, 0x13, 0xcb, 0xff, 0x43, 0xe7, 0x60, 0xad, 0x6d, 0xed, 0xd9, 0x5a, 0xef,
	0x51, 0xcb, 0x50, 0x1b, 0x5d, 0x5d, 0x96, 0x10, 0x82, 0x4a, 0xcf, 0xd2, 0xb1, 0x6d, 0xf5, 0xac,
	0x47, 0x7a, 0x47, 0xd3, 0x35, 0x39, 0x87, 0xd6, 0xa1, 0x9c, 0xd8, 0x9a, 0x8d, 0x4e, 0x47, 0xd7,
	0xe4, 0xa5, 0x89, 0x53, 0xd7, 0x68, 0xeb, 0x9a, 0x6d, 0xf6, 0xba, 0xf2, 0x32, 0xaa, 0x00, 0xe8,
	0x6d, 0xb3, 0xab, 0xdb, 0x66, 0xa7, 0xf5, 0x44, 0x5e, 0x41, 0x6b, 0x50, 0xb2, 0x5a, 0xe6, 0x63,
	0xbb, 0x6d, 0x6a, 0xba, 0x9c, 0xe7, 0x90, 0x07, 0x66, 0xab, 0x65, 0x3e, 0xd6, 0xb1, 0x95, 0xba,
	0x14, 0xd0, 0x25, 0x38, 0x3f, 0x6d, 0xb3, 0xf7, 0x75, 0x6c, 0xca, 0xc5, 0x04, 0xdb, 0x6b, 0x0a,
	0xbf, 0x12, 0x17, 0x8d, 0xef, 0x7d, 0x95, 0x32, 0x01, 0xba, 0x0a, 0x17, 0x9b, 0x2d, 0x63, 0x7f,
	0xbf, 0x81, 0x35, 0x5b, 0x35, 0x3b, 0x1d, 0x5d, 0xed, 0xa6, 0x9f, 0xca, 0xb5, 0x5c, 0x51, 0x42,
	0x17, 0x40, 0xfe, 0x5a, 0xc7, 0xc6, 0x03, 0x43, 0xd7, 0xec, 0x86, 0xaa, 0x9a, 0xbd, 0x4e, 0x57,
	0x5e, 0xe5, 0x56, 0xf5, 0x21, 0x97, 0xdf, 0xb2, 0x2d, 0xbd, 0xdb, 0x35, 0x3a, 0x7b, 0x96, 0xbc,
	0x86, 0x64, 0x58, 0x6d, 0xf4, 0xba, 0x66, 0xdb, 0xd4, 0xec, 0x87, 0x7a, 0x4b, 0x93, 0x2b, 0xdc,
	0xaf, 0xad, 0x5b, 0x56, 0x63, 0x4f, 0xb7, 0xb1, 0xfe, 0xa5, 0xae, 0x76, 0x75, 0x4d, 0x5e, 0xdf,
	0xfd, 0xbb, 0x00, 0xcb, 0xaa, 0x3f, 0x22, 0x28, 0x86, 0xca, 0xf4, 0xc8, 0x8e, 0x76, 0xb2, 0x37,
	0x69, 0xe6, 0x8f, 0x82, 0xda, 0xed, 0xc5, 0x01, 0xa2, 0x9a, 0x7e, 0x00, 0x74, 0x72, 0x0e, 0x47,
	0x77, 0xb2, 0x79, 0x32, 0xc7, 0xff, 0xda, 0x47, 0x6f, 0x06, 0x12, 0x02, 0x5e, 0x4a, 0x70, 0x29,
	0x63, 0x8c, 0x46, 0x77, 0xe7, 0x17, 0x69, 0xf6, 0x84, 0x5f, 0xbb, 0xf7, 0x16, 0x48, 0x21, 0xe8,
	0x27, 0x09, 0x36, 0x66, 0x8f, 0xc0, 0xe8, 0xd3, 0xf9, 0xac, 0x99, 0xb3, 0x79, 0xed, 0xee, 0x9b,
	0x03, 0x85, 0x9a, 0xdf, 0xa4, 0x74, 0xe6, 0x9c, 0x3b, 0x73, 0xa1, 0xe6, 0x7c, 0xfe, 0x45, 0xe6,
	0xc7, 0x9a, 0xfa, 0xaf, 0x38, 0x8e, 0xed, 0x66, 0xc6, 0xe4, 0x34, 0x6f, 0x37, 0xe7, 0x4f, 0x77,
	0xf3, 0x76, 0xf3, 0xb4, 0x31, 0xed, 0x17, 0x09, 0x2e, 0x67, 0xce, 0xec, 0xe8, 0xb3, 0xf9, 0x6b,
	0x9e, 0xf7, 0xbb, 0xa4, 0x76, 0xff, 0xad, 0xb0, 0xa9, 0xac, 0xe6, 0xcd, 0xfd, 0x1b, 0xd3, 0xe8,
	0x1d, 0x8e, 0xde, 0x61, 0x43, 0x6f, 0x87, 0x33, 0xa4, 0xff, 0x07, 0x24, 0x8f, 0x07, 0xf9, 0xe4,
	0xf9, 0xce, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xfc, 0x14, 0xa7, 0x12, 0x51, 0x10, 0x00, 0x00,
}
