// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: debug.proto

package nioh

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// ==================
// DebugAPI Interface
// ==================

type DebugAPI interface {
	ResetPreview(context.Context, *ResetPreviewRequest) (*ResetPreviewResponse, error)
}

// ========================
// DebugAPI Protobuf Client
// ========================

type debugAPIProtobufClient struct {
	client HTTPClient
	urls   [1]string
}

// NewDebugAPIProtobufClient creates a Protobuf client that implements the DebugAPI interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewDebugAPIProtobufClient(addr string, client HTTPClient) DebugAPI {
	prefix := urlBase(addr) + DebugAPIPathPrefix
	urls := [1]string{
		prefix + "ResetPreview",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &debugAPIProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &debugAPIProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *debugAPIProtobufClient) ResetPreview(ctx context.Context, in *ResetPreviewRequest) (*ResetPreviewResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "nioh")
	ctx = ctxsetters.WithServiceName(ctx, "DebugAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ResetPreview")
	out := new(ResetPreviewResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

// ====================
// DebugAPI JSON Client
// ====================

type debugAPIJSONClient struct {
	client HTTPClient
	urls   [1]string
}

// NewDebugAPIJSONClient creates a JSON client that implements the DebugAPI interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewDebugAPIJSONClient(addr string, client HTTPClient) DebugAPI {
	prefix := urlBase(addr) + DebugAPIPathPrefix
	urls := [1]string{
		prefix + "ResetPreview",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &debugAPIJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &debugAPIJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *debugAPIJSONClient) ResetPreview(ctx context.Context, in *ResetPreviewRequest) (*ResetPreviewResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "nioh")
	ctx = ctxsetters.WithServiceName(ctx, "DebugAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ResetPreview")
	out := new(ResetPreviewResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

// =======================
// DebugAPI Server Handler
// =======================

type debugAPIServer struct {
	DebugAPI
	hooks *twirp.ServerHooks
}

func NewDebugAPIServer(svc DebugAPI, hooks *twirp.ServerHooks) TwirpServer {
	return &debugAPIServer{
		DebugAPI: svc,
		hooks:    hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *debugAPIServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// DebugAPIPathPrefix is used for all URL paths on a twirp DebugAPI server.
// Requests are always: POST DebugAPIPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const DebugAPIPathPrefix = "/twirp/nioh.DebugAPI/"

func (s *debugAPIServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "nioh")
	ctx = ctxsetters.WithServiceName(ctx, "DebugAPI")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/nioh.DebugAPI/ResetPreview":
		s.serveResetPreview(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *debugAPIServer) serveResetPreview(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveResetPreviewJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveResetPreviewProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *debugAPIServer) serveResetPreviewJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResetPreview")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ResetPreviewRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResetPreviewResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ResetPreview(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResetPreviewResponse and nil error while calling ResetPreview. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *debugAPIServer) serveResetPreviewProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResetPreview")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ResetPreviewRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResetPreviewResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ResetPreview(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResetPreviewResponse and nil error while calling ResetPreview. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *debugAPIServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 0
}

func (s *debugAPIServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

var twirpFileDescriptor1 = []byte{
	// 191 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xe2, 0x4e, 0x49, 0x4d, 0x2a,
	0x4d, 0xd7, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0x62, 0xc9, 0xcb, 0xcc, 0xcf, 0x50, 0xf2, 0xe5,
	0x12, 0x0e, 0x4a, 0x2d, 0x4e, 0x2d, 0x09, 0x28, 0x4a, 0x2d, 0xcb, 0x4c, 0x2d, 0x0f, 0x4a, 0x2d,
	0x2c, 0x4d, 0x2d, 0x2e, 0x11, 0x12, 0xe7, 0x62, 0x2f, 0x2d, 0x4e, 0x2d, 0x8a, 0xcf, 0x4c, 0x91,
	0x60, 0x54, 0x60, 0xd4, 0xe0, 0x0c, 0x62, 0x03, 0x71, 0x3d, 0x53, 0x84, 0x64, 0xb9, 0xb8, 0x92,
	0x33, 0x12, 0xf3, 0xf2, 0x52, 0x73, 0x40, 0x72, 0x4c, 0x60, 0x39, 0x4e, 0xa8, 0x88, 0x67, 0x8a,
	0x52, 0x36, 0x97, 0x08, 0xaa, 0x71, 0xc5, 0x05, 0xf9, 0x79, 0xc5, 0xa9, 0xe4, 0x9a, 0x27, 0x24,
	0xcd, 0xc5, 0x59, 0x9e, 0x58, 0x1c, 0x5f, 0x04, 0x32, 0x53, 0x82, 0x59, 0x81, 0x51, 0x83, 0x23,
	0x88, 0xa3, 0x3c, 0xb1, 0x18, 0x6c, 0x87, 0x51, 0x20, 0x17, 0x87, 0x0b, 0xc8, 0x43, 0x8e, 0x01,
	0x9e, 0x42, 0xae, 0x5c, 0x3c, 0xc8, 0x16, 0x0b, 0x49, 0xea, 0x81, 0xbc, 0xa7, 0x87, 0xc5, 0x6f,
	0x52, 0x52, 0xd8, 0xa4, 0x20, 0xee, 0x74, 0x62, 0x8b, 0x02, 0x07, 0x4b, 0x12, 0x1b, 0x38, 0x8c,
	0x8c, 0x01, 0x01, 0x00, 0x00, 0xff, 0xff, 0x73, 0x3f, 0xde, 0xc3, 0x32, 0x01, 0x00, 0x00,
}
