// Code generated by protoc-gen-go. DO NOT EDIT.
// source: models.proto

/*
Package nioh is a generated protocol buffer package.

It is generated from these files:
	models.proto
	responses.proto
	requests.proto
	service.proto
	restriction_option.proto
	debug.proto

It has these top-level messages:
	Chanlet
	ContentAttribute
	ChannelRelation
	Channel
	VOD
	Restriction
	ChannelRestrictionResponse
	Exemption
	UserAuthorizationForResource
	RestrictionResource
	RestrictionResourceResponse
	OwnerChanletAttributes
	Record
	GetUserAuthorizationResponse
	GetUserAuthorizationsByResourcesResponse
	ListAuthorizedUsersResponse
	ListAuthorizedUsersResponseV2
	GetChanletsResponse
	IsHiddenChanletResponse
	BulkIsHiddenChanletResponse
	CreateChanletResponse
	ArchiveChanletResponse
	UpdateChanletContentAttributesResponse
	CreateContentAttributesResponse
	GetContentAttributesForChannelResponse
	GetContentAttributesForChanletResponse
	UpdateContentAttributesResponse
	DeleteContentAttributesResponse
	CreateContentAttributeImageUploadConfigResponse
	CreateChannelRelationResponse
	DeleteChannelRelationResponse
	GetChannelRelationsResponse
	GetChanletStreamKeyResponse
	GetChannelRestrictionResponse
	GetChannelRestrictionsResponse
	GetRestrictionsByResourcesResponse
	MutateResourceRestrictionResponse
	GetPermissionsResponse
	GetOwnerChanletAttributesResponse
	UpdateOwnerChanletAttributesResponse
	GetRecordRequest
	GetUserAuthorizationRequest
	GetUserAuthorizationsByResourcesRequest
	ListAuthorizedUsersRequest
	ListAuthorizedUsersRequestV2
	GetChanletsRequest
	IsHiddenChanletRequest
	BulkIsHiddenChanletRequest
	CreateChanletRequest
	ArchiveChanletRequest
	UpdateChanletContentAttributesRequest
	CreateContentAttributesRequest
	GetContentAttributesForChannelRequest
	GetContentAttributesForChanletRequest
	UpdateContentAttributesRequest
	DeleteContentAttributesRequest
	CreateContentAttributeImageUploadConfigRequest
	CreateChannelRelationRequest
	DeleteChannelRelationRequest
	GetChannelRelationsRequest
	GetChanletStreamKeyRequest
	GetChannelRestrictionRequest
	GetChannelRestrictionsRequest
	GetRestrictionsByResourcesRequest
	SetResourceRestrictionRequest
	DeleteResourceRestrictionRequest
	GetPermissionsRequest
	GetOwnerChanletAttributesRequest
	UpdateOwnerChanletAttributesRequest
	ResetPreviewRequest
	ResetPreviewResponse
*/
package nioh

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// ChanletSort indicates the desired order of chanlets in a GetChanletsResponse.
type ChanletSort int32

const (
	// NONE indicates no desired sort order. Chanlets are not guaranteed to return in any ordering, but may return in
	// some natural ordering dependent on the implementation.
	ChanletSort_NONE ChanletSort = 0
	// VIEWER_COUNT indicates a desired sort on viewer count. Chanlets will return in descending order by viewer count.
	ChanletSort_VIEWER_COUNT ChanletSort = 1
)

var ChanletSort_name = map[int32]string{
	0: "NONE",
	1: "VIEWER_COUNT",
}
var ChanletSort_value = map[string]int32{
	"NONE":         0,
	"VIEWER_COUNT": 1,
}

func (x ChanletSort) String() string {
	return proto.EnumName(ChanletSort_name, int32(x))
}
func (ChanletSort) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type ResourceType int32

const (
	// UNKNOWN is the catch-all default when parsing malformed or incompatible ResourceType values.
	// It should *never* appear in business logic, as it represents a value that cannot be meaningfully understood
	// by the Protobuf schema. It should never be an expected variant within application code.
	ResourceType_UNKNOWN ResourceType = 0
	// LIVE represents a live stream resource.
	ResourceType_LIVE ResourceType = 1
	// VIDEO represents a video-on-demand (VOD) resource.
	ResourceType_VIDEO ResourceType = 2
)

var ResourceType_name = map[int32]string{
	0: "UNKNOWN",
	1: "LIVE",
	2: "VIDEO",
}
var ResourceType_value = map[string]int32{
	"UNKNOWN": 0,
	"LIVE":    1,
	"VIDEO":   2,
}

func (x ResourceType) String() string {
	return proto.EnumName(ResourceType_name, int32(x))
}
func (ResourceType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// RestrictionType indicates the _product intent_ of the restriction (i.e.,
// what feature on Twitch does this restriction serve to implement?
//
// RestrictionType does _not_ necessarily describe the details of the policy represented by this restriction,
// which is better described by the Exemptions list.
//
// RestrictionType is best thought of as presentation data.
type Restriction_RestrictionType int32

const (
	// UNKNOWN is the catch-all default when parsing malformed or incompatible RestrictionType values.
	// It should *never* appear in business logic, as it represents a _present_ restriction that cannot be
	// understood by the Protobuf schema. It does not represent the absence of a restriction.
	Restriction_UNKNOWN Restriction_RestrictionType = 0
	// SUB_ONLY_LIVE represents a restriction implementing sub-only functionality. This is a feature available to
	// affiliates and partners allowing them to restriction livestreams and VODs to subscribers only.
	Restriction_SUB_ONLY_LIVE Restriction_RestrictionType = 1
	// ALL_ACCESS_PASS represents a restriction implementing the Overwatch League All-Access Pass premium content policy
	Restriction_ALL_ACCESS_PASS Restriction_RestrictionType = 2
	// ORGANIZATION_ACCESS_ONLY represents a restriction implementing by checkings on the organization of the channel's owner and that of the viewer.
	// RBAC is managing the user - company relationship: https://git-aws.internal.justin.tv/devrel/devsite-rbac
	Restriction_ORGANIZATION_ACCESS_ONLY Restriction_RestrictionType = 3
)

var Restriction_RestrictionType_name = map[int32]string{
	0: "UNKNOWN",
	1: "SUB_ONLY_LIVE",
	2: "ALL_ACCESS_PASS",
	3: "ORGANIZATION_ACCESS_ONLY",
}
var Restriction_RestrictionType_value = map[string]int32{
	"UNKNOWN":                  0,
	"SUB_ONLY_LIVE":            1,
	"ALL_ACCESS_PASS":          2,
	"ORGANIZATION_ACCESS_ONLY": 3,
}

func (x Restriction_RestrictionType) String() string {
	return proto.EnumName(Restriction_RestrictionType_name, int32(x))
}
func (Restriction_RestrictionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{5, 0}
}

// ExemptionType describes the mechanism that tests whether a given user is granted access based on the Exemption.
type Exemption_ExemptionType int32

const (
	// UNKNOWN is the catch-all default when parsing malformed or incompatible ExemptionType values.
	// It should *never* appear in business logic, as it represents a value that cannot be meaningfully understood
	// by the Protobuf schema. It does not represent the absence of an exemption.
	Exemption_UNKNOWN Exemption_ExemptionType = 0
	// ALL indicates that the exemption grants all users (including anonymous users) access during its active period.
	// This is used to implement free trial windows, for example.
	Exemption_ALL Exemption_ExemptionType = 1
	// STAFF indicates that the exemption grants all staff users (as determined by querying Users service)
	// access during its active period.
	Exemption_STAFF Exemption_ExemptionType = 2
	// SITE_ADMIN indicates that the exemption grants all site admin users (as determined by querying Users service)
	// access during its active period.
	Exemption_SITE_ADMIN Exemption_ExemptionType = 3
	// PRODUCT indicates that the exemption grants access to users who possess an active subscription to one or more
	// specified ticket products. The ticket product IDs are specified in the exemption_keys field. A user only needs
	// a subscription to _any_ of the specified product IDs, not _all_ of them.
	Exemption_PRODUCT Exemption_ExemptionType = 4
	// PREVIEW indicates that the exemption grants temporary access to users via Nioh's preview mechanism. Previews
	// are scoped per-user, per-time-window, and are activated by calling GetUserAuthorization with consume_preview=true.
	Exemption_PREVIEW Exemption_ExemptionType = 5
	// CHANNEL_VIP indicates that the exemption grants access to users who are designated channel VIPs by the broadcaster.
	Exemption_CHANNEL_VIP Exemption_ExemptionType = 6
	// CHANNEL_MODERATOR indicates that the exemption grants access to users who are designated channel moderators by the broadcaster.
	Exemption_CHANNEL_MODERATOR Exemption_ExemptionType = 7
	// ORGANIZATION_MEMBER indicates that the exemption grants access to users who are in the same organization(company) as the channel owner.
	Exemption_ORGANIZATION_MEMBER Exemption_ExemptionType = 8
)

var Exemption_ExemptionType_name = map[int32]string{
	0: "UNKNOWN",
	1: "ALL",
	2: "STAFF",
	3: "SITE_ADMIN",
	4: "PRODUCT",
	5: "PREVIEW",
	6: "CHANNEL_VIP",
	7: "CHANNEL_MODERATOR",
	8: "ORGANIZATION_MEMBER",
}
var Exemption_ExemptionType_value = map[string]int32{
	"UNKNOWN":             0,
	"ALL":                 1,
	"STAFF":               2,
	"SITE_ADMIN":          3,
	"PRODUCT":             4,
	"PREVIEW":             5,
	"CHANNEL_VIP":         6,
	"CHANNEL_MODERATOR":   7,
	"ORGANIZATION_MEMBER": 8,
}

func (x Exemption_ExemptionType) String() string {
	return proto.EnumName(Exemption_ExemptionType_name, int32(x))
}
func (Exemption_ExemptionType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

// Response Data Types
type Chanlet struct {
	OwnerChannelId    string              `protobuf:"bytes,1,opt,name=owner_channel_id,json=ownerChannelId" json:"owner_channel_id,omitempty"`
	ChanletId         string              `protobuf:"bytes,2,opt,name=chanlet_id,json=chanletId" json:"chanlet_id,omitempty"`
	ContentAttributes []*ContentAttribute `protobuf:"bytes,4,rep,name=content_attributes,json=contentAttributes" json:"content_attributes,omitempty"`
}

func (m *Chanlet) Reset()                    { *m = Chanlet{} }
func (m *Chanlet) String() string            { return proto.CompactTextString(m) }
func (*Chanlet) ProtoMessage()               {}
func (*Chanlet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Chanlet) GetOwnerChannelId() string {
	if m != nil {
		return m.OwnerChannelId
	}
	return ""
}

func (m *Chanlet) GetChanletId() string {
	if m != nil {
		return m.ChanletId
	}
	return ""
}

func (m *Chanlet) GetContentAttributes() []*ContentAttribute {
	if m != nil {
		return m.ContentAttributes
	}
	return nil
}

type ContentAttribute struct {
	OwnerChannelId     string                     `protobuf:"bytes,1,opt,name=owner_channel_id,json=ownerChannelId" json:"owner_channel_id,omitempty"`
	Id                 string                     `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	AttributeKey       string                     `protobuf:"bytes,3,opt,name=attribute_key,json=attributeKey" json:"attribute_key,omitempty"`
	AttributeName      string                     `protobuf:"bytes,4,opt,name=attribute_name,json=attributeName" json:"attribute_name,omitempty"`
	Value              string                     `protobuf:"bytes,5,opt,name=value" json:"value,omitempty"`
	ValueShortname     string                     `protobuf:"bytes,6,opt,name=value_shortname,json=valueShortname" json:"value_shortname,omitempty"`
	ParentAttributeId  string                     `protobuf:"bytes,7,opt,name=parent_attribute_id,json=parentAttributeId" json:"parent_attribute_id,omitempty"`
	ParentAttributeKey string                     `protobuf:"bytes,8,opt,name=parent_attribute_key,json=parentAttributeKey" json:"parent_attribute_key,omitempty"`
	ImageUrl           string                     `protobuf:"bytes,9,opt,name=image_url,json=imageUrl" json:"image_url,omitempty"`
	CreatedAt          *google_protobuf.Timestamp `protobuf:"bytes,10,opt,name=createdAt" json:"createdAt,omitempty"`
	UpdatedAt          *google_protobuf.Timestamp `protobuf:"bytes,11,opt,name=updatedAt" json:"updatedAt,omitempty"`
	ChildAttributeIds  []string                   `protobuf:"bytes,12,rep,name=child_attribute_ids,json=childAttributeIds" json:"child_attribute_ids,omitempty"`
}

func (m *ContentAttribute) Reset()                    { *m = ContentAttribute{} }
func (m *ContentAttribute) String() string            { return proto.CompactTextString(m) }
func (*ContentAttribute) ProtoMessage()               {}
func (*ContentAttribute) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ContentAttribute) GetOwnerChannelId() string {
	if m != nil {
		return m.OwnerChannelId
	}
	return ""
}

func (m *ContentAttribute) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ContentAttribute) GetAttributeKey() string {
	if m != nil {
		return m.AttributeKey
	}
	return ""
}

func (m *ContentAttribute) GetAttributeName() string {
	if m != nil {
		return m.AttributeName
	}
	return ""
}

func (m *ContentAttribute) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *ContentAttribute) GetValueShortname() string {
	if m != nil {
		return m.ValueShortname
	}
	return ""
}

func (m *ContentAttribute) GetParentAttributeId() string {
	if m != nil {
		return m.ParentAttributeId
	}
	return ""
}

func (m *ContentAttribute) GetParentAttributeKey() string {
	if m != nil {
		return m.ParentAttributeKey
	}
	return ""
}

func (m *ContentAttribute) GetImageUrl() string {
	if m != nil {
		return m.ImageUrl
	}
	return ""
}

func (m *ContentAttribute) GetCreatedAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *ContentAttribute) GetUpdatedAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *ContentAttribute) GetChildAttributeIds() []string {
	if m != nil {
		return m.ChildAttributeIds
	}
	return nil
}

// DEPRECATED
type ChannelRelation struct {
	ChannelId        string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	RelatedChannelId string `protobuf:"bytes,2,opt,name=related_channel_id,json=relatedChannelId" json:"related_channel_id,omitempty"`
	Relation         string `protobuf:"bytes,3,opt,name=relation" json:"relation,omitempty"`
}

func (m *ChannelRelation) Reset()                    { *m = ChannelRelation{} }
func (m *ChannelRelation) String() string            { return proto.CompactTextString(m) }
func (*ChannelRelation) ProtoMessage()               {}
func (*ChannelRelation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ChannelRelation) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *ChannelRelation) GetRelatedChannelId() string {
	if m != nil {
		return m.RelatedChannelId
	}
	return ""
}

func (m *ChannelRelation) GetRelation() string {
	if m != nil {
		return m.Relation
	}
	return ""
}

// Channel represents a paywalled channel resource. The required entitlement to pass the paywall is stored within
// Nioh's ChannelRestrictions DynamoDB table.
type Channel struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *Channel) Reset()                    { *m = Channel{} }
func (m *Channel) String() string            { return proto.CompactTextString(m) }
func (*Channel) ProtoMessage()               {}
func (*Channel) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Channel) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// VOD represents a paywalled VOD resource. The required entitlement to pass the paywall is communicated in the
// hedwig_reason_data field, sourced from Hedwig's database of restrictions.
type VOD struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	VideoId   string `protobuf:"bytes,2,opt,name=video_id,json=videoId" json:"video_id,omitempty"`
	// hedwig_reason_data should be string-encoded JSON that includes a productName field indicating a ticket product
	// whose entitlement allows accessing the paywalled VOD.
	HedwigReasonData string `protobuf:"bytes,3,opt,name=hedwig_reason_data,json=hedwigReasonData" json:"hedwig_reason_data,omitempty"`
}

func (m *VOD) Reset()                    { *m = VOD{} }
func (m *VOD) String() string            { return proto.CompactTextString(m) }
func (*VOD) ProtoMessage()               {}
func (*VOD) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *VOD) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *VOD) GetVideoId() string {
	if m != nil {
		return m.VideoId
	}
	return ""
}

func (m *VOD) GetHedwigReasonData() string {
	if m != nil {
		return m.HedwigReasonData
	}
	return ""
}

// Restriction represents an access control whose policy is represented by Exemptions. A resource associated with a restriction
// is inaccessible by a user unless that user is exempted by one of the Restriction's Exemptions.
//
// A populated Restriction message _always_ represents a populated restriction within Nioh. An absent restriction,
// indicating an unrestricted resource, is represented by an empty Restriction message.
//
// Restriction is a refinement of ChannelRestriction to decouple it from channels, add RestrictionType, and orient toward
// having a list of exemptions instead of 1:1.
type Restriction struct {
	Id              string                      `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	RestrictionType Restriction_RestrictionType `protobuf:"varint,2,opt,name=restriction_type,json=restrictionType,enum=nioh.Restriction_RestrictionType" json:"restriction_type,omitempty"`
	Exemptions      []*Exemption                `protobuf:"bytes,3,rep,name=exemptions" json:"exemptions,omitempty"`
	Options         []Option                    `protobuf:"varint,4,rep,packed,name=options,enum=nioh.restriction_option.Option" json:"options,omitempty"`
}

func (m *Restriction) Reset()                    { *m = Restriction{} }
func (m *Restriction) String() string            { return proto.CompactTextString(m) }
func (*Restriction) ProtoMessage()               {}
func (*Restriction) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *Restriction) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Restriction) GetRestrictionType() Restriction_RestrictionType {
	if m != nil {
		return m.RestrictionType
	}
	return Restriction_UNKNOWN
}

func (m *Restriction) GetExemptions() []*Exemption {
	if m != nil {
		return m.Exemptions
	}
	return nil
}

func (m *Restriction) GetOptions() []Option {
	if m != nil {
		return m.Options
	}
	return nil
}

// ChannelRestrictionResponse wraps Restriction with API response context
type ChannelRestrictionResponse struct {
	ChannelId   string       `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Restriction *Restriction `protobuf:"bytes,2,opt,name=restriction" json:"restriction,omitempty"`
	Error       string       `protobuf:"bytes,3,opt,name=error" json:"error,omitempty"`
}

func (m *ChannelRestrictionResponse) Reset()                    { *m = ChannelRestrictionResponse{} }
func (m *ChannelRestrictionResponse) String() string            { return proto.CompactTextString(m) }
func (*ChannelRestrictionResponse) ProtoMessage()               {}
func (*ChannelRestrictionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ChannelRestrictionResponse) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *ChannelRestrictionResponse) GetRestriction() *Restriction {
	if m != nil {
		return m.Restriction
	}
	return nil
}

func (m *ChannelRestrictionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// Exemption represents a policy that conditionally grants a user access to a resource protected by a Restriction.
type Exemption struct {
	ExemptionType Exemption_ExemptionType `protobuf:"varint,1,opt,name=exemption_type,json=exemptionType,enum=nioh.Exemption_ExemptionType" json:"exemption_type,omitempty"`
	// active_start_date describes at what time the Exemption begins granting users access. If a user passes the criteria for
	// access as indicated by exemption_type, but the instant of access is before active_start_date, the user is not
	// granted access by the exemption.
	ActiveStartDate *google_protobuf.Timestamp `protobuf:"bytes,2,opt,name=active_start_date,json=activeStartDate" json:"active_start_date,omitempty"`
	// active_end_date describes at what time the Exemption stops granting users access.
	ActiveEndDate *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=active_end_date,json=activeEndDate" json:"active_end_date,omitempty"`
	// exemption_keys are arbitrary string values that inform how eligibility for this exemption is calculated.
	// Significance per exemption type:
	// UNKNOWN: N/A
	// ALL: N/A
	// STAFF: N/A
	// SITE_ADMIN: N/A
	// PRODUCT: A list of ticket product IDs. Possession of at least one of these ticket products exempts the user.
	ExemptionKeys []string            `protobuf:"bytes,4,rep,name=exemption_keys,json=exemptionKeys" json:"exemption_keys,omitempty"`
	Actions       []*Exemption_Action `protobuf:"bytes,5,rep,name=actions" json:"actions,omitempty"`
}

func (m *Exemption) Reset()                    { *m = Exemption{} }
func (m *Exemption) String() string            { return proto.CompactTextString(m) }
func (*Exemption) ProtoMessage()               {}
func (*Exemption) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *Exemption) GetExemptionType() Exemption_ExemptionType {
	if m != nil {
		return m.ExemptionType
	}
	return Exemption_UNKNOWN
}

func (m *Exemption) GetActiveStartDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.ActiveStartDate
	}
	return nil
}

func (m *Exemption) GetActiveEndDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.ActiveEndDate
	}
	return nil
}

func (m *Exemption) GetExemptionKeys() []string {
	if m != nil {
		return m.ExemptionKeys
	}
	return nil
}

func (m *Exemption) GetActions() []*Exemption_Action {
	if m != nil {
		return m.Actions
	}
	return nil
}

type Exemption_Action struct {
	Name  string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Title string `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
}

func (m *Exemption_Action) Reset()                    { *m = Exemption_Action{} }
func (m *Exemption_Action) String() string            { return proto.CompactTextString(m) }
func (*Exemption_Action) ProtoMessage()               {}
func (*Exemption_Action) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

func (m *Exemption_Action) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Exemption_Action) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

type UserAuthorizationForResource struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// user_is_authorized indicates whether the user is granted access to the requested resource.
	UserIsAuthorized bool `protobuf:"varint,2,opt,name=user_is_authorized,json=userIsAuthorized" json:"user_is_authorized,omitempty"`
	// resource_is_restricted indicates whether a restriction exists for the requested resource. A false value in this field
	// indicates that the resource is unrestricted.
	ResourceIsRestricted bool `protobuf:"varint,3,opt,name=resource_is_restricted,json=resourceIsRestricted" json:"resource_is_restricted,omitempty"`
	// resource indicates the resource that the user intends to access.
	//
	// Types that are valid to be assigned to Resource:
	//	*UserAuthorizationForResource_Channel
	//	*UserAuthorizationForResource_Vod
	Resource isUserAuthorizationForResource_Resource `protobuf_oneof:"resource"`
	// applied_exemptions lists the exemptions that granted the user access, if any. This can be useful presentation data.
	// If user_is_authorized = false, applied_exemptions will be empty, since no exemptions granted the user access.
	// If resource_is_restricted = false, applied_exemptions will be empty, since no exemptions can exist without a restriction.
	AppliedExemptions []*Exemption                `protobuf:"bytes,6,rep,name=applied_exemptions,json=appliedExemptions" json:"applied_exemptions,omitempty"`
	Error             string                      `protobuf:"bytes,7,opt,name=error" json:"error,omitempty"`
	RestrictionType   Restriction_RestrictionType `protobuf:"varint,8,opt,name=restriction_type,json=restrictionType,enum=nioh.Restriction_RestrictionType" json:"restriction_type,omitempty"`
}

func (m *UserAuthorizationForResource) Reset()                    { *m = UserAuthorizationForResource{} }
func (m *UserAuthorizationForResource) String() string            { return proto.CompactTextString(m) }
func (*UserAuthorizationForResource) ProtoMessage()               {}
func (*UserAuthorizationForResource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type isUserAuthorizationForResource_Resource interface {
	isUserAuthorizationForResource_Resource()
}

type UserAuthorizationForResource_Channel struct {
	Channel *Channel `protobuf:"bytes,4,opt,name=channel,oneof"`
}
type UserAuthorizationForResource_Vod struct {
	Vod *VOD `protobuf:"bytes,5,opt,name=vod,oneof"`
}

func (*UserAuthorizationForResource_Channel) isUserAuthorizationForResource_Resource() {}
func (*UserAuthorizationForResource_Vod) isUserAuthorizationForResource_Resource()     {}

func (m *UserAuthorizationForResource) GetResource() isUserAuthorizationForResource_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *UserAuthorizationForResource) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UserAuthorizationForResource) GetUserIsAuthorized() bool {
	if m != nil {
		return m.UserIsAuthorized
	}
	return false
}

func (m *UserAuthorizationForResource) GetResourceIsRestricted() bool {
	if m != nil {
		return m.ResourceIsRestricted
	}
	return false
}

func (m *UserAuthorizationForResource) GetChannel() *Channel {
	if x, ok := m.GetResource().(*UserAuthorizationForResource_Channel); ok {
		return x.Channel
	}
	return nil
}

func (m *UserAuthorizationForResource) GetVod() *VOD {
	if x, ok := m.GetResource().(*UserAuthorizationForResource_Vod); ok {
		return x.Vod
	}
	return nil
}

func (m *UserAuthorizationForResource) GetAppliedExemptions() []*Exemption {
	if m != nil {
		return m.AppliedExemptions
	}
	return nil
}

func (m *UserAuthorizationForResource) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *UserAuthorizationForResource) GetRestrictionType() Restriction_RestrictionType {
	if m != nil {
		return m.RestrictionType
	}
	return Restriction_UNKNOWN
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UserAuthorizationForResource) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UserAuthorizationForResource_OneofMarshaler, _UserAuthorizationForResource_OneofUnmarshaler, _UserAuthorizationForResource_OneofSizer, []interface{}{
		(*UserAuthorizationForResource_Channel)(nil),
		(*UserAuthorizationForResource_Vod)(nil),
	}
}

func _UserAuthorizationForResource_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UserAuthorizationForResource)
	// resource
	switch x := m.Resource.(type) {
	case *UserAuthorizationForResource_Channel:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Channel); err != nil {
			return err
		}
	case *UserAuthorizationForResource_Vod:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Vod); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UserAuthorizationForResource.Resource has unexpected type %T", x)
	}
	return nil
}

func _UserAuthorizationForResource_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UserAuthorizationForResource)
	switch tag {
	case 4: // resource.channel
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Channel)
		err := b.DecodeMessage(msg)
		m.Resource = &UserAuthorizationForResource_Channel{msg}
		return true, err
	case 5: // resource.vod
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VOD)
		err := b.DecodeMessage(msg)
		m.Resource = &UserAuthorizationForResource_Vod{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UserAuthorizationForResource_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UserAuthorizationForResource)
	// resource
	switch x := m.Resource.(type) {
	case *UserAuthorizationForResource_Channel:
		s := proto.Size(x.Channel)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserAuthorizationForResource_Vod:
		s := proto.Size(x.Vod)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type RestrictionResource struct {
	Id   string       `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Type ResourceType `protobuf:"varint,2,opt,name=type,enum=nioh.ResourceType" json:"type,omitempty"`
}

func (m *RestrictionResource) Reset()                    { *m = RestrictionResource{} }
func (m *RestrictionResource) String() string            { return proto.CompactTextString(m) }
func (*RestrictionResource) ProtoMessage()               {}
func (*RestrictionResource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *RestrictionResource) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RestrictionResource) GetType() ResourceType {
	if m != nil {
		return m.Type
	}
	return ResourceType_UNKNOWN
}

// RestrictionResourceResponse wraps Restriction with API response context
type RestrictionResourceResponse struct {
	// A resource can be one of the following, but not multiple. Currently unable to use "oneof" because the
	// generic inteface generated is doesn't work well for response types
	Id          string       `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Type        ResourceType `protobuf:"varint,2,opt,name=type,enum=nioh.ResourceType" json:"type,omitempty"`
	Restriction *Restriction `protobuf:"bytes,3,opt,name=restriction" json:"restriction,omitempty"`
	Error       string       `protobuf:"bytes,4,opt,name=error" json:"error,omitempty"`
}

func (m *RestrictionResourceResponse) Reset()                    { *m = RestrictionResourceResponse{} }
func (m *RestrictionResourceResponse) String() string            { return proto.CompactTextString(m) }
func (*RestrictionResourceResponse) ProtoMessage()               {}
func (*RestrictionResourceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *RestrictionResourceResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RestrictionResourceResponse) GetType() ResourceType {
	if m != nil {
		return m.Type
	}
	return ResourceType_UNKNOWN
}

func (m *RestrictionResourceResponse) GetRestriction() *Restriction {
	if m != nil {
		return m.Restriction
	}
	return nil
}

func (m *RestrictionResourceResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type OwnerChanletAttributes struct {
	ChanletsEnabled bool `protobuf:"varint,1,opt,name=chanlets_enabled,json=chanletsEnabled" json:"chanlets_enabled,omitempty"`
}

func (m *OwnerChanletAttributes) Reset()                    { *m = OwnerChanletAttributes{} }
func (m *OwnerChanletAttributes) String() string            { return proto.CompactTextString(m) }
func (*OwnerChanletAttributes) ProtoMessage()               {}
func (*OwnerChanletAttributes) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *OwnerChanletAttributes) GetChanletsEnabled() bool {
	if m != nil {
		return m.ChanletsEnabled
	}
	return false
}

func init() {
	proto.RegisterType((*Chanlet)(nil), "nioh.Chanlet")
	proto.RegisterType((*ContentAttribute)(nil), "nioh.ContentAttribute")
	proto.RegisterType((*ChannelRelation)(nil), "nioh.ChannelRelation")
	proto.RegisterType((*Channel)(nil), "nioh.Channel")
	proto.RegisterType((*VOD)(nil), "nioh.VOD")
	proto.RegisterType((*Restriction)(nil), "nioh.Restriction")
	proto.RegisterType((*ChannelRestrictionResponse)(nil), "nioh.ChannelRestrictionResponse")
	proto.RegisterType((*Exemption)(nil), "nioh.Exemption")
	proto.RegisterType((*Exemption_Action)(nil), "nioh.Exemption.Action")
	proto.RegisterType((*UserAuthorizationForResource)(nil), "nioh.UserAuthorizationForResource")
	proto.RegisterType((*RestrictionResource)(nil), "nioh.RestrictionResource")
	proto.RegisterType((*RestrictionResourceResponse)(nil), "nioh.RestrictionResourceResponse")
	proto.RegisterType((*OwnerChanletAttributes)(nil), "nioh.OwnerChanletAttributes")
	proto.RegisterEnum("nioh.ChanletSort", ChanletSort_name, ChanletSort_value)
	proto.RegisterEnum("nioh.ResourceType", ResourceType_name, ResourceType_value)
	proto.RegisterEnum("nioh.Restriction_RestrictionType", Restriction_RestrictionType_name, Restriction_RestrictionType_value)
	proto.RegisterEnum("nioh.Exemption_ExemptionType", Exemption_ExemptionType_name, Exemption_ExemptionType_value)
}

func init() { proto.RegisterFile("models.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1218 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xcd, 0x6e, 0xdb, 0x46,
	0x17, 0xb5, 0x44, 0x59, 0x3f, 0x57, 0xb6, 0x34, 0x1a, 0xe7, 0x4b, 0x14, 0x27, 0x41, 0xfc, 0xb1,
	0x48, 0xeb, 0x04, 0x85, 0x12, 0x28, 0x5d, 0xb4, 0x9b, 0x02, 0xb4, 0x44, 0x37, 0x6c, 0x64, 0xd2,
	0xa0, 0x64, 0x07, 0xcd, 0x86, 0xa0, 0xc5, 0x5b, 0x8b, 0x08, 0x45, 0x0a, 0xc3, 0x91, 0x53, 0xe7,
	0x01, 0x8a, 0xbe, 0x40, 0x57, 0x5d, 0xb4, 0x2f, 0xd2, 0x17, 0xeb, 0xaa, 0xe0, 0x0c, 0x49, 0x51,
	0x8a, 0x51, 0x23, 0x59, 0x49, 0x73, 0xee, 0xb9, 0xc3, 0xfb, 0x7b, 0x48, 0xd8, 0x99, 0x47, 0x1e,
	0x06, 0x71, 0x6f, 0xc1, 0x22, 0x1e, 0xd1, 0x4a, 0xe8, 0x47, 0xb3, 0xfd, 0xc7, 0x97, 0x51, 0x74,
	0x19, 0xe0, 0x73, 0x81, 0x5d, 0x2c, 0x7f, 0x7e, 0xce, 0xfd, 0x39, 0xc6, 0xdc, 0x9d, 0x2f, 0x24,
	0x6d, 0xbf, 0xcb, 0x30, 0xe6, 0xcc, 0x9f, 0x72, 0x3f, 0x0a, 0x9d, 0x68, 0x91, 0xfc, 0x48, 0x8b,
	0xfa, 0x67, 0x09, 0x6a, 0x83, 0x99, 0x1b, 0x06, 0xc8, 0xe9, 0x21, 0x90, 0xe8, 0x7d, 0x88, 0xcc,
	0x99, 0xce, 0xdc, 0x30, 0xc4, 0xc0, 0xf1, 0xbd, 0x6e, 0xe9, 0xa0, 0x74, 0xd8, 0xb0, 0x5b, 0x02,
	0x1f, 0x48, 0xd8, 0xf0, 0xe8, 0x23, 0x80, 0xa9, 0x74, 0x4a, 0x38, 0x65, 0xc1, 0x69, 0xa4, 0x88,
	0xe1, 0x51, 0x1d, 0xe8, 0x34, 0x0a, 0x39, 0x86, 0xdc, 0x71, 0x39, 0x67, 0xfe, 0xc5, 0x92, 0x63,
	0xdc, 0xad, 0x1c, 0x28, 0x87, 0xcd, 0xfe, 0xdd, 0x5e, 0x12, 0x72, 0x6f, 0x20, 0xed, 0x5a, 0x66,
	0xb6, 0x3b, 0xd3, 0x0d, 0x24, 0xfe, 0xb1, 0x52, 0x57, 0x48, 0x45, 0xfd, 0x47, 0x01, 0xb2, 0xc9,
	0xfe, 0x84, 0x50, 0x5b, 0x50, 0xce, 0x43, 0x2c, 0xfb, 0x1e, 0xfd, 0x02, 0x76, 0xf3, 0x98, 0x9c,
	0x77, 0x78, 0xdd, 0x55, 0x84, 0x69, 0x27, 0x07, 0x5f, 0xe3, 0x35, 0x7d, 0x02, 0xad, 0x15, 0x29,
	0x74, 0xe7, 0xd8, 0xad, 0x08, 0xd6, 0xca, 0xd5, 0x74, 0xe7, 0x48, 0xef, 0xc0, 0xf6, 0x95, 0x1b,
	0x2c, 0xb1, 0xbb, 0x2d, 0xac, 0xf2, 0x40, 0xbf, 0x82, 0xb6, 0xf8, 0xe3, 0xc4, 0xb3, 0x88, 0x71,
	0xe1, 0x5d, 0x95, 0xa1, 0x09, 0x78, 0x9c, 0xa1, 0xb4, 0x07, 0x7b, 0x0b, 0x97, 0xad, 0x55, 0x29,
	0xc9, 0xa3, 0x26, 0xc8, 0x1d, 0x69, 0xca, 0x53, 0x36, 0x3c, 0xfa, 0x02, 0xee, 0x7c, 0xc4, 0x4f,
	0x32, 0xa8, 0x0b, 0x07, 0xba, 0xe1, 0x90, 0xe4, 0xf1, 0x00, 0x1a, 0xfe, 0xdc, 0xbd, 0x44, 0x67,
	0xc9, 0x82, 0x6e, 0x43, 0xd0, 0xea, 0x02, 0x38, 0x63, 0x01, 0xfd, 0x16, 0x1a, 0x53, 0x86, 0x2e,
	0x47, 0x4f, 0xe3, 0x5d, 0x38, 0x28, 0x1d, 0x36, 0xfb, 0xfb, 0x3d, 0x39, 0x49, 0xbd, 0x6c, 0x92,
	0x7a, 0x93, 0x6c, 0x92, 0xec, 0x15, 0x39, 0xf1, 0x5c, 0x2e, 0xbc, 0xd4, 0xb3, 0x79, 0xbb, 0x67,
	0x4e, 0x4e, 0x52, 0x9e, 0xce, 0xfc, 0xc0, 0x5b, 0xcb, 0x38, 0xee, 0xee, 0x1c, 0x28, 0x49, 0xca,
	0xc2, 0x54, 0xc8, 0x38, 0x56, 0x3f, 0x40, 0x3b, 0x6d, 0xa5, 0x8d, 0x81, 0x9b, 0xcc, 0x6d, 0x36,
	0x7b, 0x6b, 0x4d, 0x6f, 0x4c, 0xf3, 0x7e, 0x7f, 0x0d, 0x94, 0x25, 0x54, 0xf4, 0x8a, 0xb3, 0x21,
	0xfb, 0x4f, 0x52, 0xcb, 0x6a, 0x3a, 0xf6, 0xa1, 0xce, 0xd2, 0x8b, 0xd3, 0x41, 0xc8, 0xcf, 0xea,
	0x7d, 0xb9, 0x19, 0x21, 0x06, 0xe9, 0x10, 0x95, 0xb2, 0x21, 0x52, 0xe7, 0xa0, 0x9c, 0x5b, 0xc3,
	0xdb, 0x42, 0xb9, 0x0f, 0xf5, 0x2b, 0xdf, 0xc3, 0x68, 0x15, 0x40, 0x4d, 0x9c, 0x65, 0x94, 0x33,
	0xf4, 0xde, 0xfb, 0x97, 0x0e, 0x43, 0x37, 0x8e, 0x42, 0xc7, 0x73, 0xb9, 0x9b, 0x46, 0x40, 0xa4,
	0xc5, 0x16, 0x86, 0xa1, 0xcb, 0x5d, 0xf5, 0xef, 0x32, 0x34, 0xed, 0xd5, 0x06, 0x6f, 0x86, 0x43,
	0x47, 0x40, 0x8a, 0x0b, 0xce, 0xaf, 0x17, 0x28, 0x1e, 0xd8, 0xea, 0xff, 0x5f, 0x6e, 0x5b, 0xc1,
	0xb9, 0xf8, 0x7f, 0x72, 0xbd, 0x40, 0xbb, 0xcd, 0xd6, 0x01, 0xfa, 0x1c, 0x00, 0x7f, 0xc1, 0xb9,
	0x50, 0x89, 0xb8, 0xab, 0x88, 0xad, 0x6d, 0xcb, 0x7b, 0xf4, 0x0c, 0xb7, 0x0b, 0x14, 0xfa, 0x1d,
	0xd4, 0xa2, 0x94, 0x9d, 0xec, 0x78, 0xab, 0xff, 0x58, 0xb2, 0x6f, 0x10, 0x1d, 0x4b, 0x7a, 0x67,
	0x7c, 0xd5, 0x83, 0xf6, 0x46, 0x3c, 0xb4, 0x09, 0xb5, 0x33, 0xf3, 0xb5, 0x69, 0xbd, 0x31, 0xc9,
	0x16, 0xed, 0xc0, 0xee, 0xf8, 0xec, 0xc8, 0xb1, 0xcc, 0xd1, 0x4f, 0xce, 0xc8, 0x38, 0xd7, 0x49,
	0x89, 0xee, 0x41, 0x5b, 0x1b, 0x8d, 0x1c, 0x6d, 0x30, 0xd0, 0xc7, 0x63, 0xe7, 0x54, 0x1b, 0x8f,
	0x49, 0x99, 0x3e, 0x84, 0xae, 0x65, 0xff, 0xa0, 0x99, 0xc6, 0x5b, 0x6d, 0x62, 0x58, 0x66, 0x66,
	0x4d, 0xfc, 0x88, 0xa2, 0xfe, 0x5a, 0x82, 0xfd, 0x7c, 0x8c, 0xf2, 0xa7, 0xd9, 0x18, 0x2f, 0xa2,
	0x30, 0xc6, 0xdb, 0xda, 0xf8, 0x12, 0x9a, 0x85, 0x4c, 0x44, 0x61, 0x9b, 0xfd, 0xce, 0x47, 0x85,
	0xb5, 0x8b, 0xac, 0x44, 0x1a, 0x90, 0xb1, 0x88, 0xa5, 0x3d, 0x95, 0x07, 0xf5, 0xb7, 0x0a, 0x34,
	0xf2, 0x1a, 0xd2, 0x21, 0xb4, 0xf2, 0x2a, 0xca, 0xa6, 0x95, 0x44, 0xd3, 0x1e, 0x6d, 0x14, 0x7b,
	0xf5, 0x4f, 0x34, 0x6c, 0x17, 0x8b, 0x47, 0x7a, 0x0c, 0x1d, 0x77, 0xca, 0xfd, 0x2b, 0x74, 0x62,
	0xee, 0x32, 0x9e, 0x4c, 0x12, 0xa6, 0x41, 0xfe, 0xd7, 0x52, 0xb6, 0xa5, 0xd3, 0x38, 0xf1, 0x19,
	0xba, 0x1c, 0xe9, 0x11, 0xa4, 0x90, 0x83, 0xa1, 0x27, 0x6f, 0x51, 0x6e, 0xbd, 0x65, 0x57, 0xba,
	0xe8, 0xa1, 0x27, 0xee, 0x78, 0x52, 0xcc, 0xe8, 0x1d, 0x5e, 0xcb, 0x81, 0x68, 0x14, 0x42, 0x7e,
	0x8d, 0xd7, 0x31, 0x7d, 0x01, 0x35, 0x77, 0x2a, 0x07, 0x66, 0xbb, 0xf8, 0x52, 0x58, 0x65, 0xac,
	0xc9, 0x92, 0x66, 0xb4, 0xfd, 0x3e, 0x54, 0x25, 0x44, 0x29, 0x54, 0x84, 0xa4, 0xca, 0x36, 0x89,
	0xff, 0x49, 0xb1, 0xb9, 0xcf, 0x03, 0x4c, 0xb7, 0x4c, 0x1e, 0xd4, 0x3f, 0x4a, 0xb0, 0xbb, 0x56,
	0xb9, 0xf5, 0xd1, 0xaa, 0x81, 0xa2, 0x8d, 0x46, 0xa4, 0x44, 0x1b, 0xb0, 0x3d, 0x9e, 0x68, 0xc7,
	0xc7, 0xa4, 0x4c, 0x5b, 0x00, 0x63, 0x63, 0xa2, 0x3b, 0xda, 0xf0, 0xc4, 0x30, 0x89, 0x92, 0x38,
	0x9c, 0xda, 0xd6, 0xf0, 0x6c, 0x30, 0x21, 0x15, 0x79, 0xd0, 0xcf, 0x0d, 0xfd, 0x0d, 0xd9, 0xa6,
	0x6d, 0x68, 0x0e, 0x5e, 0x69, 0xa6, 0xa9, 0x8f, 0x9c, 0x73, 0xe3, 0x94, 0x54, 0xe9, 0xff, 0xa0,
	0x93, 0x01, 0x27, 0xd6, 0x50, 0xb7, 0xb5, 0x89, 0x65, 0x93, 0x1a, 0xbd, 0x07, 0x7b, 0x6b, 0x83,
	0x79, 0xa2, 0x9f, 0x1c, 0xe9, 0x36, 0xa9, 0xab, 0xbf, 0x2b, 0xf0, 0xf0, 0x2c, 0x46, 0xa6, 0x2d,
	0xf9, 0x2c, 0x62, 0xfe, 0x07, 0xa1, 0x39, 0xc7, 0x11, 0xb3, 0x31, 0x8e, 0x96, 0x6c, 0x8a, 0xf4,
	0x1e, 0xd4, 0x96, 0x31, 0xb2, 0xd5, 0x48, 0x56, 0x93, 0xa3, 0xd4, 0x0e, 0x69, 0x88, 0x1d, 0x37,
	0x75, 0x46, 0x29, 0x30, 0x75, 0x9b, 0x08, 0x4e, 0xac, 0xe5, 0x38, 0xfd, 0x06, 0xee, 0xb2, 0xf4,
	0xca, 0xc4, 0x23, 0x9b, 0x51, 0xf4, 0x44, 0x77, 0xeb, 0xf6, 0x9d, 0xcc, 0x6a, 0xc4, 0x76, 0x6e,
	0xa3, 0x4f, 0xa1, 0x96, 0x2e, 0x80, 0x78, 0xf3, 0x35, 0xfb, 0xbb, 0xe9, 0x6b, 0x5b, 0x82, 0xaf,
	0xb6, 0xec, 0xcc, 0x4e, 0x1f, 0x81, 0x72, 0x15, 0x79, 0xe2, 0x15, 0xd8, 0xec, 0x37, 0x24, 0xed,
	0xdc, 0x1a, 0xbe, 0xda, 0xb2, 0x13, 0x9c, 0x7e, 0x0f, 0xd4, 0x5d, 0x2c, 0x02, 0x1f, 0x3d, 0xa7,
	0xa0, 0x2a, 0xd5, 0x9b, 0x55, 0xa5, 0x93, 0x52, 0xf5, 0x95, 0xb8, 0xe4, 0x8b, 0x54, 0x2b, 0x2c,
	0xd2, 0x8d, 0x8a, 0x57, 0xff, 0x5c, 0xc5, 0x3b, 0x82, 0xe4, 0x2d, 0x20, 0xab, 0xa0, 0x9e, 0xc0,
	0xde, 0xba, 0x46, 0xc8, 0x6e, 0x6c, 0x4a, 0xee, 0x97, 0x50, 0x29, 0xc8, 0x2c, 0xcd, 0x1f, 0x2a,
	0xd8, 0xe2, 0x29, 0xc2, 0xae, 0xfe, 0x55, 0x82, 0x07, 0x37, 0xdc, 0x97, 0x6b, 0xcf, 0x67, 0xde,
	0xbb, 0x29, 0x4a, 0xca, 0xa7, 0x89, 0x52, 0xa5, 0x28, 0x4a, 0x03, 0xb8, 0x6b, 0x65, 0xdf, 0x4c,
	0x01, 0x16, 0x3e, 0xc0, 0xe8, 0x53, 0x20, 0xe9, 0x47, 0x5d, 0xec, 0x60, 0xe8, 0x5e, 0x04, 0x28,
	0x43, 0xad, 0xdb, 0xed, 0x0c, 0xd7, 0x25, 0xfc, 0xec, 0x29, 0x34, 0x53, 0xff, 0x71, 0xc4, 0x38,
	0xad, 0x43, 0xc5, 0xb4, 0x4c, 0x9d, 0x6c, 0x51, 0x02, 0x3b, 0xc9, 0xca, 0xe8, 0xb6, 0x33, 0xb0,
	0xce, 0xcc, 0x09, 0x29, 0x3d, 0x7b, 0x01, 0x3b, 0xc5, 0x84, 0xd6, 0xb7, 0xb2, 0x0e, 0x95, 0x54,
	0xe7, 0x1b, 0xb0, 0x7d, 0x6e, 0x0c, 0x75, 0x8b, 0x94, 0x8f, 0xaa, 0x6f, 0xc5, 0x77, 0xee, 0x45,
	0x55, 0x28, 0xd0, 0xcb, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x84, 0x9e, 0x96, 0xea, 0x04, 0x0b,
	0x00, 0x00,
}
