// Code generated by protoc-gen-go. DO NOT EDIT.
// source: requests.proto

package nioh

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type GetRecordRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	RecordId  string `protobuf:"bytes,2,opt,name=record_id,json=recordId" json:"record_id,omitempty"`
}

func (m *GetRecordRequest) Reset()                    { *m = GetRecordRequest{} }
func (m *GetRecordRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRecordRequest) ProtoMessage()               {}
func (*GetRecordRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *GetRecordRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetRecordRequest) GetRecordId() string {
	if m != nil {
		return m.RecordId
	}
	return ""
}

type GetUserAuthorizationRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// Types that are valid to be assigned to Resource:
	//	*GetUserAuthorizationRequest_Channel
	//	*GetUserAuthorizationRequest_Vod
	Resource       isGetUserAuthorizationRequest_Resource `protobuf_oneof:"resource"`
	ConsumePreview bool                                   `protobuf:"varint,4,opt,name=consume_preview,json=consumePreview" json:"consume_preview,omitempty"`
	// Optional origin parameter used generate free preview tokens
	Origin string `protobuf:"bytes,5,opt,name=origin" json:"origin,omitempty"`
}

func (m *GetUserAuthorizationRequest) Reset()                    { *m = GetUserAuthorizationRequest{} }
func (m *GetUserAuthorizationRequest) String() string            { return proto.CompactTextString(m) }
func (*GetUserAuthorizationRequest) ProtoMessage()               {}
func (*GetUserAuthorizationRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

type isGetUserAuthorizationRequest_Resource interface {
	isGetUserAuthorizationRequest_Resource()
}

type GetUserAuthorizationRequest_Channel struct {
	Channel *Channel `protobuf:"bytes,2,opt,name=channel,oneof"`
}
type GetUserAuthorizationRequest_Vod struct {
	Vod *VOD `protobuf:"bytes,3,opt,name=vod,oneof"`
}

func (*GetUserAuthorizationRequest_Channel) isGetUserAuthorizationRequest_Resource() {}
func (*GetUserAuthorizationRequest_Vod) isGetUserAuthorizationRequest_Resource()     {}

func (m *GetUserAuthorizationRequest) GetResource() isGetUserAuthorizationRequest_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *GetUserAuthorizationRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetUserAuthorizationRequest) GetChannel() *Channel {
	if x, ok := m.GetResource().(*GetUserAuthorizationRequest_Channel); ok {
		return x.Channel
	}
	return nil
}

func (m *GetUserAuthorizationRequest) GetVod() *VOD {
	if x, ok := m.GetResource().(*GetUserAuthorizationRequest_Vod); ok {
		return x.Vod
	}
	return nil
}

func (m *GetUserAuthorizationRequest) GetConsumePreview() bool {
	if m != nil {
		return m.ConsumePreview
	}
	return false
}

func (m *GetUserAuthorizationRequest) GetOrigin() string {
	if m != nil {
		return m.Origin
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GetUserAuthorizationRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GetUserAuthorizationRequest_OneofMarshaler, _GetUserAuthorizationRequest_OneofUnmarshaler, _GetUserAuthorizationRequest_OneofSizer, []interface{}{
		(*GetUserAuthorizationRequest_Channel)(nil),
		(*GetUserAuthorizationRequest_Vod)(nil),
	}
}

func _GetUserAuthorizationRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GetUserAuthorizationRequest)
	// resource
	switch x := m.Resource.(type) {
	case *GetUserAuthorizationRequest_Channel:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Channel); err != nil {
			return err
		}
	case *GetUserAuthorizationRequest_Vod:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Vod); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("GetUserAuthorizationRequest.Resource has unexpected type %T", x)
	}
	return nil
}

func _GetUserAuthorizationRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GetUserAuthorizationRequest)
	switch tag {
	case 2: // resource.channel
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Channel)
		err := b.DecodeMessage(msg)
		m.Resource = &GetUserAuthorizationRequest_Channel{msg}
		return true, err
	case 3: // resource.vod
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VOD)
		err := b.DecodeMessage(msg)
		m.Resource = &GetUserAuthorizationRequest_Vod{msg}
		return true, err
	default:
		return false, nil
	}
}

func _GetUserAuthorizationRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GetUserAuthorizationRequest)
	// resource
	switch x := m.Resource.(type) {
	case *GetUserAuthorizationRequest_Channel:
		s := proto.Size(x.Channel)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GetUserAuthorizationRequest_Vod:
		s := proto.Size(x.Vod)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type GetUserAuthorizationsByResourcesRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// Channels and VODs have very different data (channels just have IDs where vods have reason data, etc)
	// It's more convenient to keep them separate especially when upstreams typically care only about one type
	Channels []*Channel `protobuf:"bytes,2,rep,name=channels" json:"channels,omitempty"`
	Vods     []*VOD     `protobuf:"bytes,3,rep,name=vods" json:"vods,omitempty"`
}

func (m *GetUserAuthorizationsByResourcesRequest) Reset() {
	*m = GetUserAuthorizationsByResourcesRequest{}
}
func (m *GetUserAuthorizationsByResourcesRequest) String() string { return proto.CompactTextString(m) }
func (*GetUserAuthorizationsByResourcesRequest) ProtoMessage()    {}
func (*GetUserAuthorizationsByResourcesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{2}
}

func (m *GetUserAuthorizationsByResourcesRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetUserAuthorizationsByResourcesRequest) GetChannels() []*Channel {
	if m != nil {
		return m.Channels
	}
	return nil
}

func (m *GetUserAuthorizationsByResourcesRequest) GetVods() []*VOD {
	if m != nil {
		return m.Vods
	}
	return nil
}

type ListAuthorizedUsersRequest struct {
	Limit  uint32 `protobuf:"varint,1,opt,name=limit" json:"limit,omitempty"`
	Offset uint32 `protobuf:"varint,2,opt,name=offset" json:"offset,omitempty"`
	// Types that are valid to be assigned to Resource:
	//	*ListAuthorizedUsersRequest_Channel
	//	*ListAuthorizedUsersRequest_Vod
	Resource isListAuthorizedUsersRequest_Resource `protobuf_oneof:"resource"`
}

func (m *ListAuthorizedUsersRequest) Reset()                    { *m = ListAuthorizedUsersRequest{} }
func (m *ListAuthorizedUsersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListAuthorizedUsersRequest) ProtoMessage()               {}
func (*ListAuthorizedUsersRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

type isListAuthorizedUsersRequest_Resource interface {
	isListAuthorizedUsersRequest_Resource()
}

type ListAuthorizedUsersRequest_Channel struct {
	Channel *Channel `protobuf:"bytes,3,opt,name=channel,oneof"`
}
type ListAuthorizedUsersRequest_Vod struct {
	Vod *VOD `protobuf:"bytes,4,opt,name=vod,oneof"`
}

func (*ListAuthorizedUsersRequest_Channel) isListAuthorizedUsersRequest_Resource() {}
func (*ListAuthorizedUsersRequest_Vod) isListAuthorizedUsersRequest_Resource()     {}

func (m *ListAuthorizedUsersRequest) GetResource() isListAuthorizedUsersRequest_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *ListAuthorizedUsersRequest) GetLimit() uint32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListAuthorizedUsersRequest) GetOffset() uint32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ListAuthorizedUsersRequest) GetChannel() *Channel {
	if x, ok := m.GetResource().(*ListAuthorizedUsersRequest_Channel); ok {
		return x.Channel
	}
	return nil
}

func (m *ListAuthorizedUsersRequest) GetVod() *VOD {
	if x, ok := m.GetResource().(*ListAuthorizedUsersRequest_Vod); ok {
		return x.Vod
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ListAuthorizedUsersRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ListAuthorizedUsersRequest_OneofMarshaler, _ListAuthorizedUsersRequest_OneofUnmarshaler, _ListAuthorizedUsersRequest_OneofSizer, []interface{}{
		(*ListAuthorizedUsersRequest_Channel)(nil),
		(*ListAuthorizedUsersRequest_Vod)(nil),
	}
}

func _ListAuthorizedUsersRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ListAuthorizedUsersRequest)
	// resource
	switch x := m.Resource.(type) {
	case *ListAuthorizedUsersRequest_Channel:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Channel); err != nil {
			return err
		}
	case *ListAuthorizedUsersRequest_Vod:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Vod); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ListAuthorizedUsersRequest.Resource has unexpected type %T", x)
	}
	return nil
}

func _ListAuthorizedUsersRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ListAuthorizedUsersRequest)
	switch tag {
	case 3: // resource.channel
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Channel)
		err := b.DecodeMessage(msg)
		m.Resource = &ListAuthorizedUsersRequest_Channel{msg}
		return true, err
	case 4: // resource.vod
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VOD)
		err := b.DecodeMessage(msg)
		m.Resource = &ListAuthorizedUsersRequest_Vod{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ListAuthorizedUsersRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ListAuthorizedUsersRequest)
	// resource
	switch x := m.Resource.(type) {
	case *ListAuthorizedUsersRequest_Channel:
		s := proto.Size(x.Channel)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListAuthorizedUsersRequest_Vod:
		s := proto.Size(x.Vod)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ListAuthorizedUsersRequestV2 struct {
	Limit  int32  `protobuf:"varint,1,opt,name=limit" json:"limit,omitempty"`
	Cursor string `protobuf:"bytes,2,opt,name=cursor" json:"cursor,omitempty"`
	// Types that are valid to be assigned to Resource:
	//	*ListAuthorizedUsersRequestV2_Channel
	//	*ListAuthorizedUsersRequestV2_Vod
	Resource isListAuthorizedUsersRequestV2_Resource `protobuf_oneof:"resource"`
}

func (m *ListAuthorizedUsersRequestV2) Reset()                    { *m = ListAuthorizedUsersRequestV2{} }
func (m *ListAuthorizedUsersRequestV2) String() string            { return proto.CompactTextString(m) }
func (*ListAuthorizedUsersRequestV2) ProtoMessage()               {}
func (*ListAuthorizedUsersRequestV2) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

type isListAuthorizedUsersRequestV2_Resource interface {
	isListAuthorizedUsersRequestV2_Resource()
}

type ListAuthorizedUsersRequestV2_Channel struct {
	Channel *Channel `protobuf:"bytes,3,opt,name=channel,oneof"`
}
type ListAuthorizedUsersRequestV2_Vod struct {
	Vod *VOD `protobuf:"bytes,4,opt,name=vod,oneof"`
}

func (*ListAuthorizedUsersRequestV2_Channel) isListAuthorizedUsersRequestV2_Resource() {}
func (*ListAuthorizedUsersRequestV2_Vod) isListAuthorizedUsersRequestV2_Resource()     {}

func (m *ListAuthorizedUsersRequestV2) GetResource() isListAuthorizedUsersRequestV2_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *ListAuthorizedUsersRequestV2) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListAuthorizedUsersRequestV2) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

func (m *ListAuthorizedUsersRequestV2) GetChannel() *Channel {
	if x, ok := m.GetResource().(*ListAuthorizedUsersRequestV2_Channel); ok {
		return x.Channel
	}
	return nil
}

func (m *ListAuthorizedUsersRequestV2) GetVod() *VOD {
	if x, ok := m.GetResource().(*ListAuthorizedUsersRequestV2_Vod); ok {
		return x.Vod
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ListAuthorizedUsersRequestV2) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ListAuthorizedUsersRequestV2_OneofMarshaler, _ListAuthorizedUsersRequestV2_OneofUnmarshaler, _ListAuthorizedUsersRequestV2_OneofSizer, []interface{}{
		(*ListAuthorizedUsersRequestV2_Channel)(nil),
		(*ListAuthorizedUsersRequestV2_Vod)(nil),
	}
}

func _ListAuthorizedUsersRequestV2_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ListAuthorizedUsersRequestV2)
	// resource
	switch x := m.Resource.(type) {
	case *ListAuthorizedUsersRequestV2_Channel:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Channel); err != nil {
			return err
		}
	case *ListAuthorizedUsersRequestV2_Vod:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Vod); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ListAuthorizedUsersRequestV2.Resource has unexpected type %T", x)
	}
	return nil
}

func _ListAuthorizedUsersRequestV2_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ListAuthorizedUsersRequestV2)
	switch tag {
	case 3: // resource.channel
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Channel)
		err := b.DecodeMessage(msg)
		m.Resource = &ListAuthorizedUsersRequestV2_Channel{msg}
		return true, err
	case 4: // resource.vod
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VOD)
		err := b.DecodeMessage(msg)
		m.Resource = &ListAuthorizedUsersRequestV2_Vod{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ListAuthorizedUsersRequestV2_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ListAuthorizedUsersRequestV2)
	// resource
	switch x := m.Resource.(type) {
	case *ListAuthorizedUsersRequestV2_Channel:
		s := proto.Size(x.Channel)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ListAuthorizedUsersRequestV2_Vod:
		s := proto.Size(x.Vod)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type GetChanletsRequest struct {
	ChannelId         string      `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	Sort              ChanletSort `protobuf:"varint,2,opt,name=sort,enum=nioh.ChanletSort" json:"sort,omitempty"`
	UserId            string      `protobuf:"bytes,3,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	BypassDisableFlag bool        `protobuf:"varint,4,opt,name=bypass_disable_flag,json=bypassDisableFlag" json:"bypass_disable_flag,omitempty"`
}

func (m *GetChanletsRequest) Reset()                    { *m = GetChanletsRequest{} }
func (m *GetChanletsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChanletsRequest) ProtoMessage()               {}
func (*GetChanletsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *GetChanletsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *GetChanletsRequest) GetSort() ChanletSort {
	if m != nil {
		return m.Sort
	}
	return ChanletSort_NONE
}

func (m *GetChanletsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetChanletsRequest) GetBypassDisableFlag() bool {
	if m != nil {
		return m.BypassDisableFlag
	}
	return false
}

type IsHiddenChanletRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *IsHiddenChanletRequest) Reset()                    { *m = IsHiddenChanletRequest{} }
func (m *IsHiddenChanletRequest) String() string            { return proto.CompactTextString(m) }
func (*IsHiddenChanletRequest) ProtoMessage()               {}
func (*IsHiddenChanletRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

func (m *IsHiddenChanletRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type BulkIsHiddenChanletRequest struct {
	ChannelIds []string `protobuf:"bytes,1,rep,name=channel_ids,json=channelIds" json:"channel_ids,omitempty"`
}

func (m *BulkIsHiddenChanletRequest) Reset()                    { *m = BulkIsHiddenChanletRequest{} }
func (m *BulkIsHiddenChanletRequest) String() string            { return proto.CompactTextString(m) }
func (*BulkIsHiddenChanletRequest) ProtoMessage()               {}
func (*BulkIsHiddenChanletRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

func (m *BulkIsHiddenChanletRequest) GetChannelIds() []string {
	if m != nil {
		return m.ChannelIds
	}
	return nil
}

type CreateChanletRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *CreateChanletRequest) Reset()                    { *m = CreateChanletRequest{} }
func (m *CreateChanletRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateChanletRequest) ProtoMessage()               {}
func (*CreateChanletRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *CreateChanletRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type ArchiveChanletRequest struct {
	UserId    string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChanletId string `protobuf:"bytes,2,opt,name=chanlet_id,json=chanletId" json:"chanlet_id,omitempty"`
}

func (m *ArchiveChanletRequest) Reset()                    { *m = ArchiveChanletRequest{} }
func (m *ArchiveChanletRequest) String() string            { return proto.CompactTextString(m) }
func (*ArchiveChanletRequest) ProtoMessage()               {}
func (*ArchiveChanletRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{9} }

func (m *ArchiveChanletRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *ArchiveChanletRequest) GetChanletId() string {
	if m != nil {
		return m.ChanletId
	}
	return ""
}

type UpdateChanletContentAttributesRequest struct {
	// identifier of the chanlet to be updated
	OwnerChannelId string `protobuf:"bytes,1,opt,name=owner_channel_id,json=ownerChannelId" json:"owner_channel_id,omitempty"`
	ChanletId      string `protobuf:"bytes,2,opt,name=chanlet_id,json=chanletId" json:"chanlet_id,omitempty"`
	// the list of new content attribute IDs that are to override the existing ones stored on the chanlet
	ContentAttributeIds []string `protobuf:"bytes,3,rep,name=content_attribute_ids,json=contentAttributeIds" json:"content_attribute_ids,omitempty"`
}

func (m *UpdateChanletContentAttributesRequest) Reset()         { *m = UpdateChanletContentAttributesRequest{} }
func (m *UpdateChanletContentAttributesRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateChanletContentAttributesRequest) ProtoMessage()    {}
func (*UpdateChanletContentAttributesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{10}
}

func (m *UpdateChanletContentAttributesRequest) GetOwnerChannelId() string {
	if m != nil {
		return m.OwnerChannelId
	}
	return ""
}

func (m *UpdateChanletContentAttributesRequest) GetChanletId() string {
	if m != nil {
		return m.ChanletId
	}
	return ""
}

func (m *UpdateChanletContentAttributesRequest) GetContentAttributeIds() []string {
	if m != nil {
		return m.ContentAttributeIds
	}
	return nil
}

type CreateContentAttributesRequest struct {
	// the channel ID that initiated the request
	// the channel ID that will be used to lookup the owner channel ID
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// list of new content attributes to be created
	// owner_channel_id and id on them should be ignored
	ContentAttributes []*ContentAttribute `protobuf:"bytes,2,rep,name=content_attributes,json=contentAttributes" json:"content_attributes,omitempty"`
}

func (m *CreateContentAttributesRequest) Reset()                    { *m = CreateContentAttributesRequest{} }
func (m *CreateContentAttributesRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateContentAttributesRequest) ProtoMessage()               {}
func (*CreateContentAttributesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{11} }

func (m *CreateContentAttributesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *CreateContentAttributesRequest) GetContentAttributes() []*ContentAttribute {
	if m != nil {
		return m.ContentAttributes
	}
	return nil
}

type GetContentAttributesForChannelRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetContentAttributesForChannelRequest) Reset()         { *m = GetContentAttributesForChannelRequest{} }
func (m *GetContentAttributesForChannelRequest) String() string { return proto.CompactTextString(m) }
func (*GetContentAttributesForChannelRequest) ProtoMessage()    {}
func (*GetContentAttributesForChannelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{12}
}

func (m *GetContentAttributesForChannelRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetContentAttributesForChanletRequest struct {
	ChanletId string `protobuf:"bytes,1,opt,name=chanlet_id,json=chanletId" json:"chanlet_id,omitempty"`
}

func (m *GetContentAttributesForChanletRequest) Reset()         { *m = GetContentAttributesForChanletRequest{} }
func (m *GetContentAttributesForChanletRequest) String() string { return proto.CompactTextString(m) }
func (*GetContentAttributesForChanletRequest) ProtoMessage()    {}
func (*GetContentAttributesForChanletRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{13}
}

func (m *GetContentAttributesForChanletRequest) GetChanletId() string {
	if m != nil {
		return m.ChanletId
	}
	return ""
}

type UpdateContentAttributesRequest struct {
	// the channel ID that initiated the request
	// the channel ID that will be used to lookup the owner channel ID
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// content attributes to be updated
	ContentAttributes []*ContentAttribute `protobuf:"bytes,2,rep,name=content_attributes,json=contentAttributes" json:"content_attributes,omitempty"`
}

func (m *UpdateContentAttributesRequest) Reset()                    { *m = UpdateContentAttributesRequest{} }
func (m *UpdateContentAttributesRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateContentAttributesRequest) ProtoMessage()               {}
func (*UpdateContentAttributesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{14} }

func (m *UpdateContentAttributesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *UpdateContentAttributesRequest) GetContentAttributes() []*ContentAttribute {
	if m != nil {
		return m.ContentAttributes
	}
	return nil
}

type DeleteContentAttributesRequest struct {
	// the channel ID that initiated the request
	// the channel ID that will be used to lookup the owner channel ID
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// IDs of content attributes to be deleted
	ContentAttributes []*ContentAttribute `protobuf:"bytes,2,rep,name=content_attributes,json=contentAttributes" json:"content_attributes,omitempty"`
}

func (m *DeleteContentAttributesRequest) Reset()                    { *m = DeleteContentAttributesRequest{} }
func (m *DeleteContentAttributesRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteContentAttributesRequest) ProtoMessage()               {}
func (*DeleteContentAttributesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{15} }

func (m *DeleteContentAttributesRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *DeleteContentAttributesRequest) GetContentAttributes() []*ContentAttribute {
	if m != nil {
		return m.ContentAttributes
	}
	return nil
}

type CreateContentAttributeImageUploadConfigRequest struct {
	// the channel ID requesting the new upload
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *CreateContentAttributeImageUploadConfigRequest) Reset() {
	*m = CreateContentAttributeImageUploadConfigRequest{}
}
func (m *CreateContentAttributeImageUploadConfigRequest) String() string {
	return proto.CompactTextString(m)
}
func (*CreateContentAttributeImageUploadConfigRequest) ProtoMessage() {}
func (*CreateContentAttributeImageUploadConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{16}
}

func (m *CreateContentAttributeImageUploadConfigRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type CreateChannelRelationRequest struct {
	ChannelId        string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	RelatedChannelId string `protobuf:"bytes,2,opt,name=related_channel_id,json=relatedChannelId" json:"related_channel_id,omitempty"`
}

func (m *CreateChannelRelationRequest) Reset()                    { *m = CreateChannelRelationRequest{} }
func (m *CreateChannelRelationRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateChannelRelationRequest) ProtoMessage()               {}
func (*CreateChannelRelationRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{17} }

func (m *CreateChannelRelationRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *CreateChannelRelationRequest) GetRelatedChannelId() string {
	if m != nil {
		return m.RelatedChannelId
	}
	return ""
}

type DeleteChannelRelationRequest struct {
	ChannelId        string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	RelatedChannelId string `protobuf:"bytes,2,opt,name=related_channel_id,json=relatedChannelId" json:"related_channel_id,omitempty"`
}

func (m *DeleteChannelRelationRequest) Reset()                    { *m = DeleteChannelRelationRequest{} }
func (m *DeleteChannelRelationRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteChannelRelationRequest) ProtoMessage()               {}
func (*DeleteChannelRelationRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{18} }

func (m *DeleteChannelRelationRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

func (m *DeleteChannelRelationRequest) GetRelatedChannelId() string {
	if m != nil {
		return m.RelatedChannelId
	}
	return ""
}

type GetChannelRelationsRequest struct {
	// Types that are valid to be assigned to Id:
	//	*GetChannelRelationsRequest_ChannelId
	//	*GetChannelRelationsRequest_RelatedChannelId
	Id isGetChannelRelationsRequest_Id `protobuf_oneof:"id"`
}

func (m *GetChannelRelationsRequest) Reset()                    { *m = GetChannelRelationsRequest{} }
func (m *GetChannelRelationsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChannelRelationsRequest) ProtoMessage()               {}
func (*GetChannelRelationsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{19} }

type isGetChannelRelationsRequest_Id interface {
	isGetChannelRelationsRequest_Id()
}

type GetChannelRelationsRequest_ChannelId struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId,oneof"`
}
type GetChannelRelationsRequest_RelatedChannelId struct {
	RelatedChannelId string `protobuf:"bytes,2,opt,name=related_channel_id,json=relatedChannelId,oneof"`
}

func (*GetChannelRelationsRequest_ChannelId) isGetChannelRelationsRequest_Id()        {}
func (*GetChannelRelationsRequest_RelatedChannelId) isGetChannelRelationsRequest_Id() {}

func (m *GetChannelRelationsRequest) GetId() isGetChannelRelationsRequest_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *GetChannelRelationsRequest) GetChannelId() string {
	if x, ok := m.GetId().(*GetChannelRelationsRequest_ChannelId); ok {
		return x.ChannelId
	}
	return ""
}

func (m *GetChannelRelationsRequest) GetRelatedChannelId() string {
	if x, ok := m.GetId().(*GetChannelRelationsRequest_RelatedChannelId); ok {
		return x.RelatedChannelId
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GetChannelRelationsRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GetChannelRelationsRequest_OneofMarshaler, _GetChannelRelationsRequest_OneofUnmarshaler, _GetChannelRelationsRequest_OneofSizer, []interface{}{
		(*GetChannelRelationsRequest_ChannelId)(nil),
		(*GetChannelRelationsRequest_RelatedChannelId)(nil),
	}
}

func _GetChannelRelationsRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GetChannelRelationsRequest)
	// id
	switch x := m.Id.(type) {
	case *GetChannelRelationsRequest_ChannelId:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ChannelId)
	case *GetChannelRelationsRequest_RelatedChannelId:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.RelatedChannelId)
	case nil:
	default:
		return fmt.Errorf("GetChannelRelationsRequest.Id has unexpected type %T", x)
	}
	return nil
}

func _GetChannelRelationsRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GetChannelRelationsRequest)
	switch tag {
	case 1: // id.channel_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Id = &GetChannelRelationsRequest_ChannelId{x}
		return true, err
	case 2: // id.related_channel_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Id = &GetChannelRelationsRequest_RelatedChannelId{x}
		return true, err
	default:
		return false, nil
	}
}

func _GetChannelRelationsRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GetChannelRelationsRequest)
	// id
	switch x := m.Id.(type) {
	case *GetChannelRelationsRequest_ChannelId:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ChannelId)))
		n += len(x.ChannelId)
	case *GetChannelRelationsRequest_RelatedChannelId:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.RelatedChannelId)))
		n += len(x.RelatedChannelId)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type GetChanletStreamKeyRequest struct {
	OwnerChannelId string `protobuf:"bytes,1,opt,name=owner_channel_id,json=ownerChannelId" json:"owner_channel_id,omitempty"`
	ChanletId      string `protobuf:"bytes,2,opt,name=chanlet_id,json=chanletId" json:"chanlet_id,omitempty"`
}

func (m *GetChanletStreamKeyRequest) Reset()                    { *m = GetChanletStreamKeyRequest{} }
func (m *GetChanletStreamKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChanletStreamKeyRequest) ProtoMessage()               {}
func (*GetChanletStreamKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{20} }

func (m *GetChanletStreamKeyRequest) GetOwnerChannelId() string {
	if m != nil {
		return m.OwnerChannelId
	}
	return ""
}

func (m *GetChanletStreamKeyRequest) GetChanletId() string {
	if m != nil {
		return m.ChanletId
	}
	return ""
}

type GetChannelRestrictionRequest struct {
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetChannelRestrictionRequest) Reset()                    { *m = GetChannelRestrictionRequest{} }
func (m *GetChannelRestrictionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChannelRestrictionRequest) ProtoMessage()               {}
func (*GetChannelRestrictionRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{21} }

func (m *GetChannelRestrictionRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetChannelRestrictionsRequest struct {
	ChannelIds []string `protobuf:"bytes,1,rep,name=channel_ids,json=channelIds" json:"channel_ids,omitempty"`
}

func (m *GetChannelRestrictionsRequest) Reset()                    { *m = GetChannelRestrictionsRequest{} }
func (m *GetChannelRestrictionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetChannelRestrictionsRequest) ProtoMessage()               {}
func (*GetChannelRestrictionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{22} }

func (m *GetChannelRestrictionsRequest) GetChannelIds() []string {
	if m != nil {
		return m.ChannelIds
	}
	return nil
}

type GetRestrictionsByResourcesRequest struct {
	Resources []*RestrictionResource `protobuf:"bytes,1,rep,name=resources" json:"resources,omitempty"`
}

func (m *GetRestrictionsByResourcesRequest) Reset()         { *m = GetRestrictionsByResourcesRequest{} }
func (m *GetRestrictionsByResourcesRequest) String() string { return proto.CompactTextString(m) }
func (*GetRestrictionsByResourcesRequest) ProtoMessage()    {}
func (*GetRestrictionsByResourcesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{23}
}

func (m *GetRestrictionsByResourcesRequest) GetResources() []*RestrictionResource {
	if m != nil {
		return m.Resources
	}
	return nil
}

type SetResourceRestrictionRequest struct {
	UserId      string               `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	OwnerId     string               `protobuf:"bytes,2,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Resource    *RestrictionResource `protobuf:"bytes,3,opt,name=resource" json:"resource,omitempty"`
	Restriction *Restriction         `protobuf:"bytes,4,opt,name=restriction" json:"restriction,omitempty"`
}

func (m *SetResourceRestrictionRequest) Reset()                    { *m = SetResourceRestrictionRequest{} }
func (m *SetResourceRestrictionRequest) String() string            { return proto.CompactTextString(m) }
func (*SetResourceRestrictionRequest) ProtoMessage()               {}
func (*SetResourceRestrictionRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{24} }

func (m *SetResourceRestrictionRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *SetResourceRestrictionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *SetResourceRestrictionRequest) GetResource() *RestrictionResource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *SetResourceRestrictionRequest) GetRestriction() *Restriction {
	if m != nil {
		return m.Restriction
	}
	return nil
}

type DeleteResourceRestrictionRequest struct {
	UserId   string               `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	OwnerId  string               `protobuf:"bytes,2,opt,name=owner_id,json=ownerId" json:"owner_id,omitempty"`
	Resource *RestrictionResource `protobuf:"bytes,3,opt,name=resource" json:"resource,omitempty"`
}

func (m *DeleteResourceRestrictionRequest) Reset()         { *m = DeleteResourceRestrictionRequest{} }
func (m *DeleteResourceRestrictionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteResourceRestrictionRequest) ProtoMessage()    {}
func (*DeleteResourceRestrictionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{25}
}

func (m *DeleteResourceRestrictionRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *DeleteResourceRestrictionRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *DeleteResourceRestrictionRequest) GetResource() *RestrictionResource {
	if m != nil {
		return m.Resource
	}
	return nil
}

type GetPermissionsRequest struct {
	UserId    string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
}

func (m *GetPermissionsRequest) Reset()                    { *m = GetPermissionsRequest{} }
func (m *GetPermissionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPermissionsRequest) ProtoMessage()               {}
func (*GetPermissionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{26} }

func (m *GetPermissionsRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetPermissionsRequest) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

type GetOwnerChanletAttributesRequest struct {
	UserId         string `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	OwnerChanletId string `protobuf:"bytes,2,opt,name=owner_chanlet_id,json=ownerChanletId" json:"owner_chanlet_id,omitempty"`
}

func (m *GetOwnerChanletAttributesRequest) Reset()         { *m = GetOwnerChanletAttributesRequest{} }
func (m *GetOwnerChanletAttributesRequest) String() string { return proto.CompactTextString(m) }
func (*GetOwnerChanletAttributesRequest) ProtoMessage()    {}
func (*GetOwnerChanletAttributesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{27}
}

func (m *GetOwnerChanletAttributesRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetOwnerChanletAttributesRequest) GetOwnerChanletId() string {
	if m != nil {
		return m.OwnerChanletId
	}
	return ""
}

type UpdateOwnerChanletAttributesRequest struct {
	UserId         string                  `protobuf:"bytes,1,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	OwnerChanletId string                  `protobuf:"bytes,2,opt,name=owner_chanlet_id,json=ownerChanletId" json:"owner_chanlet_id,omitempty"`
	Attributes     *OwnerChanletAttributes `protobuf:"bytes,3,opt,name=attributes" json:"attributes,omitempty"`
}

func (m *UpdateOwnerChanletAttributesRequest) Reset()         { *m = UpdateOwnerChanletAttributesRequest{} }
func (m *UpdateOwnerChanletAttributesRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateOwnerChanletAttributesRequest) ProtoMessage()    {}
func (*UpdateOwnerChanletAttributesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{28}
}

func (m *UpdateOwnerChanletAttributesRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UpdateOwnerChanletAttributesRequest) GetOwnerChanletId() string {
	if m != nil {
		return m.OwnerChanletId
	}
	return ""
}

func (m *UpdateOwnerChanletAttributesRequest) GetAttributes() *OwnerChanletAttributes {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func init() {
	proto.RegisterType((*GetRecordRequest)(nil), "nioh.GetRecordRequest")
	proto.RegisterType((*GetUserAuthorizationRequest)(nil), "nioh.GetUserAuthorizationRequest")
	proto.RegisterType((*GetUserAuthorizationsByResourcesRequest)(nil), "nioh.GetUserAuthorizationsByResourcesRequest")
	proto.RegisterType((*ListAuthorizedUsersRequest)(nil), "nioh.ListAuthorizedUsersRequest")
	proto.RegisterType((*ListAuthorizedUsersRequestV2)(nil), "nioh.ListAuthorizedUsersRequestV2")
	proto.RegisterType((*GetChanletsRequest)(nil), "nioh.GetChanletsRequest")
	proto.RegisterType((*IsHiddenChanletRequest)(nil), "nioh.IsHiddenChanletRequest")
	proto.RegisterType((*BulkIsHiddenChanletRequest)(nil), "nioh.BulkIsHiddenChanletRequest")
	proto.RegisterType((*CreateChanletRequest)(nil), "nioh.CreateChanletRequest")
	proto.RegisterType((*ArchiveChanletRequest)(nil), "nioh.ArchiveChanletRequest")
	proto.RegisterType((*UpdateChanletContentAttributesRequest)(nil), "nioh.UpdateChanletContentAttributesRequest")
	proto.RegisterType((*CreateContentAttributesRequest)(nil), "nioh.CreateContentAttributesRequest")
	proto.RegisterType((*GetContentAttributesForChannelRequest)(nil), "nioh.GetContentAttributesForChannelRequest")
	proto.RegisterType((*GetContentAttributesForChanletRequest)(nil), "nioh.GetContentAttributesForChanletRequest")
	proto.RegisterType((*UpdateContentAttributesRequest)(nil), "nioh.UpdateContentAttributesRequest")
	proto.RegisterType((*DeleteContentAttributesRequest)(nil), "nioh.DeleteContentAttributesRequest")
	proto.RegisterType((*CreateContentAttributeImageUploadConfigRequest)(nil), "nioh.CreateContentAttributeImageUploadConfigRequest")
	proto.RegisterType((*CreateChannelRelationRequest)(nil), "nioh.CreateChannelRelationRequest")
	proto.RegisterType((*DeleteChannelRelationRequest)(nil), "nioh.DeleteChannelRelationRequest")
	proto.RegisterType((*GetChannelRelationsRequest)(nil), "nioh.GetChannelRelationsRequest")
	proto.RegisterType((*GetChanletStreamKeyRequest)(nil), "nioh.GetChanletStreamKeyRequest")
	proto.RegisterType((*GetChannelRestrictionRequest)(nil), "nioh.GetChannelRestrictionRequest")
	proto.RegisterType((*GetChannelRestrictionsRequest)(nil), "nioh.GetChannelRestrictionsRequest")
	proto.RegisterType((*GetRestrictionsByResourcesRequest)(nil), "nioh.GetRestrictionsByResourcesRequest")
	proto.RegisterType((*SetResourceRestrictionRequest)(nil), "nioh.SetResourceRestrictionRequest")
	proto.RegisterType((*DeleteResourceRestrictionRequest)(nil), "nioh.DeleteResourceRestrictionRequest")
	proto.RegisterType((*GetPermissionsRequest)(nil), "nioh.GetPermissionsRequest")
	proto.RegisterType((*GetOwnerChanletAttributesRequest)(nil), "nioh.GetOwnerChanletAttributesRequest")
	proto.RegisterType((*UpdateOwnerChanletAttributesRequest)(nil), "nioh.UpdateOwnerChanletAttributesRequest")
}

func init() { proto.RegisterFile("requests.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 938 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0xe1, 0x6e, 0xe3, 0x44,
	0x10, 0xae, 0x9b, 0xb4, 0x4d, 0xa6, 0xb4, 0xb4, 0xbe, 0xbb, 0x92, 0xeb, 0x35, 0x10, 0x8c, 0xaa,
	0x2b, 0x12, 0xca, 0x8f, 0x9c, 0x4e, 0xf7, 0x87, 0x93, 0x68, 0x52, 0x9a, 0x44, 0x20, 0x7a, 0xf2,
	0xa9, 0xf7, 0x03, 0x21, 0x45, 0xae, 0x77, 0x9a, 0xae, 0xce, 0xf1, 0x86, 0xdd, 0x75, 0x4f, 0xe5,
	0x01, 0xf8, 0x05, 0xef, 0x80, 0x00, 0xf1, 0x1a, 0x3c, 0x01, 0xef, 0x84, 0xbc, 0xbb, 0x89, 0xed,
	0x38, 0x6e, 0x8d, 0xc4, 0x71, 0xfc, 0xdc, 0x99, 0xd9, 0xf9, 0xbe, 0xf9, 0x76, 0x76, 0xd6, 0x86,
	0x6d, 0x8e, 0xdf, 0x47, 0x28, 0xa4, 0x68, 0x4f, 0x39, 0x93, 0xcc, 0xae, 0x86, 0x94, 0x5d, 0xed,
	0xbf, 0x37, 0x61, 0x04, 0x03, 0x63, 0x73, 0xbe, 0x81, 0x9d, 0x3e, 0x4a, 0x17, 0x7d, 0xc6, 0x89,
	0xab, 0xc3, 0xed, 0x26, 0x80, 0x7f, 0xe5, 0x85, 0x21, 0x06, 0x23, 0x4a, 0x1a, 0x56, 0xcb, 0x3a,
	0xaa, 0xbb, 0x75, 0x63, 0x19, 0x12, 0xfb, 0x11, 0xd4, 0xb9, 0x8a, 0x8f, 0xbd, 0xab, 0xca, 0x5b,
	0xd3, 0x86, 0x21, 0x71, 0xfe, 0xb2, 0xe0, 0x51, 0x1f, 0xe5, 0xb9, 0x40, 0x7e, 0x1c, 0xc9, 0x2b,
	0xc6, 0xe9, 0x0f, 0x9e, 0xa4, 0x2c, 0x9c, 0xe5, 0xfe, 0x00, 0x36, 0x22, 0x81, 0x3c, 0x49, 0xbc,
	0x1e, 0x2f, 0x87, 0xc4, 0xfe, 0x14, 0x36, 0x0c, 0x84, 0xca, 0xb9, 0xd9, 0xd9, 0x6a, 0xc7, 0x74,
	0xdb, 0x3d, 0x6d, 0x1c, 0xac, 0xb8, 0x33, 0xbf, 0xdd, 0x84, 0xca, 0x35, 0x23, 0x8d, 0x8a, 0x0a,
	0xab, 0xeb, 0xb0, 0x57, 0x67, 0x27, 0x83, 0x15, 0x37, 0xb6, 0xdb, 0x8f, 0xe1, 0x7d, 0x9f, 0x85,
	0x22, 0x9a, 0xe0, 0x68, 0xca, 0xf1, 0x9a, 0xe2, 0x9b, 0x46, 0xb5, 0x65, 0x1d, 0xd5, 0xdc, 0x6d,
	0x63, 0x7e, 0xa1, 0xad, 0xf6, 0x1e, 0xac, 0x33, 0x4e, 0xc7, 0x34, 0x6c, 0xac, 0x69, 0x2a, 0x7a,
	0xd5, 0x05, 0xa8, 0x71, 0x14, 0x2c, 0xe2, 0x3e, 0x3a, 0x3f, 0x59, 0xf0, 0x78, 0x59, 0x3d, 0xa2,
	0x7b, 0xe3, 0x9a, 0x18, 0x51, 0xa2, 0xb6, 0x9a, 0xe1, 0x2e, 0x1a, 0xab, 0xad, 0x4a, 0xae, 0x38,
	0x77, 0xee, 0xb6, 0x9b, 0x50, 0xbd, 0x66, 0x44, 0x34, 0x2a, 0x2a, 0x2c, 0x29, 0xce, 0x55, 0x66,
	0xe7, 0x17, 0x0b, 0xf6, 0xbf, 0xa6, 0x42, 0xce, 0xb8, 0x20, 0x89, 0x99, 0xcd, 0x19, 0xdc, 0x87,
	0xb5, 0x80, 0x4e, 0xa8, 0x54, 0xf8, 0x5b, 0xae, 0x5e, 0xa8, 0x3a, 0x2f, 0x2f, 0x05, 0x4a, 0xa5,
	0xec, 0x96, 0x6b, 0x56, 0x69, 0xc9, 0x2b, 0xe5, 0x24, 0xaf, 0x2e, 0x97, 0x3c, 0xa3, 0xd8, 0xaf,
	0x16, 0x1c, 0x14, 0x53, 0x7c, 0xd5, 0xc9, 0x92, 0x5c, 0x4b, 0x91, 0xf4, 0x23, 0x2e, 0x18, 0x37,
	0x2d, 0x65, 0x56, 0x6f, 0x89, 0xe4, 0x6f, 0x16, 0xd8, 0x7d, 0x94, 0x71, 0x92, 0x00, 0xa5, 0x28,
	0xd9, 0xf9, 0x87, 0x50, 0x15, 0x8c, 0x6b, 0x19, 0xb7, 0x3b, 0xbb, 0x09, 0x91, 0x00, 0xe5, 0x4b,
	0xc6, 0xa5, 0xab, 0xdc, 0xe9, 0x3e, 0xa8, 0x64, 0xfa, 0xa0, 0x0d, 0xf7, 0x2e, 0x6e, 0xa6, 0x9e,
	0x10, 0x23, 0x42, 0x85, 0x77, 0x11, 0xe0, 0xe8, 0x32, 0xf0, 0xc6, 0xa6, 0x3b, 0x77, 0xb5, 0xeb,
	0x44, 0x7b, 0x4e, 0x03, 0x6f, 0xec, 0x3c, 0x83, 0xbd, 0xa1, 0x18, 0x50, 0x42, 0x30, 0x34, 0x28,
	0xe5, 0x88, 0x3a, 0xcf, 0x61, 0xbf, 0x1b, 0x05, 0xaf, 0x0b, 0x36, 0x7f, 0x04, 0x9b, 0xc9, 0x66,
	0xd1, 0xb0, 0x5a, 0x95, 0xa3, 0xba, 0x0b, 0xf3, 0xdd, 0xc2, 0x79, 0x0a, 0xf7, 0x7b, 0x1c, 0x3d,
	0x89, 0xff, 0x0c, 0xf5, 0x0c, 0x1e, 0x1c, 0x73, 0xff, 0x8a, 0x5e, 0x2f, 0xee, 0x2b, 0xbc, 0x18,
	0x26, 0x61, 0x80, 0x32, 0x99, 0x25, 0x75, 0x63, 0x19, 0x12, 0xe7, 0x77, 0x0b, 0x0e, 0xcf, 0xa7,
	0x24, 0x21, 0xd2, 0x63, 0xa1, 0xc4, 0x50, 0x1e, 0x4b, 0xc9, 0xe9, 0x45, 0x24, 0x93, 0xab, 0x77,
	0x04, 0x3b, 0xec, 0x4d, 0x88, 0x7c, 0x94, 0xe3, 0xb7, 0xad, 0xec, 0xbd, 0xf9, 0x19, 0xde, 0x0e,
	0x69, 0x77, 0xe0, 0x81, 0xaf, 0x41, 0x46, 0xde, 0x0c, 0x45, 0xa9, 0x54, 0x51, 0x2a, 0xdd, 0xf3,
	0x17, 0x18, 0xc4, 0x72, 0xfd, 0x68, 0xc1, 0x87, 0x46, 0xaf, 0x22, 0x7e, 0x77, 0x34, 0xd6, 0x97,
	0x60, 0xe7, 0x50, 0x67, 0xa3, 0x62, 0xcf, 0xb4, 0xd9, 0x42, 0x6a, 0x77, 0x77, 0x91, 0x8a, 0x70,
	0x4e, 0xe1, 0xb0, 0xbf, 0x44, 0xa4, 0x53, 0x36, 0xab, 0xbf, 0xe4, 0x41, 0xde, 0x9e, 0x27, 0xdf,
	0x10, 0x46, 0x4c, 0x6b, 0xf1, 0xfc, 0x62, 0x61, 0xcc, 0xf9, 0xbd, 0x5b, 0x61, 0x62, 0x22, 0x27,
	0x18, 0xe0, 0x3b, 0x27, 0x72, 0x06, 0xed, 0xe5, 0x9d, 0x32, 0x9c, 0x78, 0x63, 0x3c, 0x9f, 0x06,
	0xcc, 0x23, 0x3d, 0x16, 0x5e, 0xd2, 0x71, 0xc9, 0xa3, 0x7a, 0x0d, 0x07, 0xc9, 0x55, 0x55, 0x27,
	0x1c, 0x64, 0xde, 0xdb, 0x3b, 0xca, 0xfa, 0x0c, 0x6c, 0x1e, 0xef, 0x40, 0x92, 0xbe, 0x39, 0xfa,
	0x56, 0xec, 0x18, 0x4f, 0x2f, 0x0d, 0x66, 0x54, 0xfc, 0x0f, 0xc0, 0x04, 0xec, 0x9b, 0x09, 0x9d,
	0x42, 0x12, 0xc9, 0x0c, 0xcb, 0x41, 0x0d, 0x56, 0xd2, 0x60, 0xed, 0x62, 0xb0, 0xc1, 0x4a, 0x1e,
	0xae, 0x5b, 0x85, 0x55, 0x4a, 0x1c, 0x9c, 0x83, 0xc6, 0x23, 0x5d, 0x72, 0xf4, 0x26, 0x5f, 0xe1,
	0xcd, 0xbf, 0x3d, 0x65, 0x9c, 0xe7, 0x70, 0x90, 0xae, 0x4d, 0x48, 0x4e, 0xfd, 0xf2, 0x42, 0x3a,
	0x5f, 0x40, 0x73, 0xe9, 0x76, 0x51, 0x7a, 0xc2, 0x7f, 0x07, 0x1f, 0xab, 0xcf, 0xbe, 0x64, 0xeb,
	0x92, 0xef, 0x99, 0x67, 0xf1, 0x87, 0x9e, 0xb1, 0xa9, 0x1c, 0x9b, 0x9d, 0x87, 0xba, 0xd5, 0x33,
	0x94, 0x75, 0x84, 0x9b, 0xc4, 0x3a, 0x7f, 0x5a, 0xd0, 0x7c, 0xa9, 0xd2, 0x6b, 0x57, 0xbe, 0xc0,
	0xc2, 0x17, 0xe1, 0x21, 0xd4, 0xb4, 0xc4, 0x73, 0xd9, 0x36, 0xd4, 0x7a, 0x48, 0xec, 0xa7, 0xc9,
	0xfb, 0x6d, 0x3e, 0x05, 0x6e, 0x61, 0x33, 0x0f, 0xb5, 0x9f, 0xc0, 0x26, 0x4f, 0x02, 0xcc, 0xd7,
	0xc1, 0x6e, 0x7e, 0x67, 0x3a, 0xca, 0xf9, 0xd9, 0x82, 0x96, 0x6e, 0xf5, 0xff, 0x45, 0x11, 0xf1,
	0xd3, 0xda, 0x47, 0xf9, 0x02, 0xf9, 0x84, 0x0a, 0x91, 0x3e, 0xe9, 0xbb, 0x9e, 0xd6, 0xcc, 0x25,
	0x4b, 0xb5, 0x10, 0x42, 0xab, 0x8f, 0xf2, 0x6c, 0xd6, 0xb5, 0x01, 0x2e, 0x19, 0x89, 0x85, 0xb9,
	0x33, 0xf7, 0x20, 0xd3, 0xe3, 0xc9, 0x3d, 0xd0, 0x8d, 0xfe, 0x87, 0x05, 0x9f, 0xe8, 0x17, 0xe0,
	0x6d, 0x43, 0xd9, 0x9f, 0x03, 0xa4, 0x26, 0xb3, 0xd6, 0xf6, 0x40, 0x6b, 0x5b, 0x80, 0x9d, 0x8a,
	0xef, 0xae, 0x7f, 0xab, 0xfe, 0x8e, 0x2e, 0xd6, 0xd5, 0x6f, 0xd1, 0x93, 0xbf, 0x03, 0x00, 0x00,
	0xff, 0xff, 0x01, 0x07, 0xda, 0xe7, 0x3c, 0x0d, 0x00, 0x00,
}
