package logger

import (
	"fmt"
	l "log"
	"os"

	"golang.org/x/net/context"

	"code.justin.tv/identity/passport/clients/rollbar"
	"code.justin.tv/sse/malachai/pkg/log"
)

// DefaultS2SLogger is passport's DefaultLogger wrapped to implement Malachai's S2SLogger interface
var DefaultS2SLogger log.S2SLogger = &wrapped{
	logger: &logger{
		logger:    l.New(os.Stdout, "", LstdFlags),
		verbosity: severities[Debug],
		rollbar:   rollbar.NewLogger("", "development"),
	},
}

type wrapped struct {
	logger Logger
}

func NewS2SLogger(l Logger) log.S2SLogger {
	return &wrapped{
		logger: l,
	}
}

func (w *wrapped) Debug(args ...interface{}) {
	w.logger.Log(context.Background(), Debug, fmt.Sprint(args...))
}

func (w *wrapped) Debugf(format string, args ...interface{}) {
	w.logger.Log(context.Background(), Debug, fmt.Sprintf(format, args...))
}

func (w *wrapped) Debugln(args ...interface{}) {
	w.logger.Log(context.Background(), Debug, fmt.Sprintln(args...))
}

func (w *wrapped) Error(args ...interface{}) {
	w.logger.Log(context.Background(), Err, fmt.Sprint(args...))
}

func (w *wrapped) Errorf(format string, args ...interface{}) {
	w.logger.Log(context.Background(), Err, fmt.Sprintf(format, args...))
}

func (w *wrapped) Errorln(args ...interface{}) {
	w.logger.Log(context.Background(), Err, fmt.Sprintln(args...))
}

func (w *wrapped) Fatal(args ...interface{}) {
	w.logger.Log(context.Background(), Fatal, fmt.Sprint(args...))
}

func (w *wrapped) Fatalf(format string, args ...interface{}) {
	w.logger.Log(context.Background(), Fatal, fmt.Sprintf(format, args...))
}

func (w *wrapped) Fatalln(args ...interface{}) {
	w.logger.Log(context.Background(), Fatal, fmt.Sprintln(args...))
}

func (w *wrapped) Info(args ...interface{}) {
	w.logger.Log(context.Background(), Info, fmt.Sprint(args...))
}

func (w *wrapped) Infof(format string, args ...interface{}) {
	w.logger.Log(context.Background(), Info, fmt.Sprintf(format, args...))
}

func (w *wrapped) Infoln(args ...interface{}) {
	w.logger.Log(context.Background(), Info, fmt.Sprintln(args...))
}

func (w *wrapped) Panic(args ...interface{}) {
	w.logger.Log(context.Background(), Critical, fmt.Sprint(args...))
}

func (w *wrapped) Panicf(format string, args ...interface{}) {
	w.logger.Log(context.Background(), Critical, fmt.Sprintf(format, args...))
}

func (w *wrapped) Panicln(args ...interface{}) {
	w.logger.Log(context.Background(), Critical, fmt.Sprintln(args...))
}

func (w *wrapped) Print(args ...interface{}) {
	w.logger.Log(context.Background(), Trace, fmt.Sprint(args...))
}

func (w *wrapped) Printf(format string, args ...interface{}) {
	w.logger.Log(context.Background(), Trace, fmt.Sprintf(format, args...))
}

func (w *wrapped) Println(args ...interface{}) {
	w.logger.Log(context.Background(), Trace, fmt.Sprintln(args...))
}

func (w *wrapped) Warn(args ...interface{}) {
	w.logger.Log(context.Background(), Warn, fmt.Sprint(args...))
}

func (w *wrapped) Warnf(format string, args ...interface{}) {
	w.logger.Log(context.Background(), Warn, fmt.Sprintf(format, args...))
}

func (w *wrapped) Warnln(args ...interface{}) {
	w.logger.Log(context.Background(), Warn, fmt.Sprintln(args...))
}
