package errors

import i18n "code.justin.tv/web/go-i18n"

var (
	// PhoneNumberAlreadyInUse represents an error raised when the user attempts to create additional
	// accounts with the same phone number.
	PhoneNumberAlreadyInUse = &WrappedError{
		InternalError: "phone number already in use",
		ExternalMessage: i18n.T(
			"Unable to create account. Please use a different phone number to continue",
			"error text when user attempts to sign up with a phone number that is already in use",
		),
		Severity: defaultLogLevel,
		Code:     7016,
	}

	// PhoneNumberIsNotMobile represents an error raised when the provided number is not a mobile phone number
	PhoneNumberIsNotMobile = &WrappedError{
		InternalError: "phone number is not mobile",
		ExternalMessage: i18n.T(
			"Unable to create account. Please use a a mobile phone number to continue",
			"error text when user attempts to sign up with a phone number that is not mobile",
		),
		Severity: defaultLogLevel,
		Code:     7017,
	}

	// Phone number is not of a valid format.
	PhoneNumberFormatInvalid = &WrappedError{
		InternalError: "phone number is not in a valid format",
		ExternalMessage: i18n.T(
			"Unable to create account. Phone number is not recognized as a phone number",
			"error text when user attempts to use a phone number that cannot be parsed as a phone number",
		),
		Severity: defaultLogLevel,
		Code:     7018,
	}

	// Invalid verification code.
	InvalidVerificationCode = &WrappedError{
		InternalError: "Verification failed due to invalid verification code ",
		ExternalMessage: i18n.T(
			"Invalid verification code. The verification code entered could not be verified",
			"error text when user attempts to verify a phone number with the wrong verification code",
		),
		Severity: defaultLogLevel,
		Code:     7019,
	}

	// Missing verification code.
	MissingVerificationCode = &WrappedError{
		InternalError: "Verification failed due to missing verification code. Verification code was sent",
		ExternalMessage: i18n.T(
			"Please enter enter the verification code received that will arrive via SMS soon",
			"text when user attempts to verify a phone number and we send an SMS",
		),
		Severity: defaultLogLevel,
		Code:     7020,
	}

	// This error represents what we throw if not one of the above errors.
	GenericTwilioError = &WrappedError{
		InternalError: "unexpected error with twilio",
		ExternalMessage: i18n.T(
			"Unknown Error, please try again",
			"error text when twilio sends us an unexpected error",
		),
		Severity: defaultLogLevel,
		Code:     7021,
	}

	// The country code of this phone number is not recognized.
	InvalidCountryCode = &WrappedError{
		InternalError: "invalid country code",
		ExternalMessage: i18n.T(
			"Unknown Error, please try again",
			"error text when twilio sends us an unexpected error",
		),
		Severity: defaultLogLevel,
		Code:     7022,
	}

	// Phone number is not of a valid format.
	PhoneNumberDoesNotExist = &WrappedError{
		InternalError: "phone number not in use",
		ExternalMessage: i18n.T(
			"Unable to create account. Phone number is not recognized as a phone number",
			"error text when user attempts to use a phone number that does not exist for the purposes of password recovery",
		),
		Severity: defaultLogLevel,
		Code:     7023,
	}

	// SMS Verify Throttled.
	SmsVerifyThrottled = &WrappedError{
		InternalError: "can't send another sms verification code since user has exceeded 10 tries in 10 minutes",
		ExternalMessage: i18n.T(
			"We've sent too many messages to this phone number recently, please try again later.",
			"error text when we can't send another sms verification code since user has exceeded 10 tries in 10 minutes",
		),
		Severity: defaultLogLevel,
		Code:     7024,
	}
)
